/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bSearchInFilesPattern.h"

#include "c2b.h"
#include "c2bBibParser.h"
#include "c2bSettings.h"

#include <QTreeWidgetItem>


c2bSearchInFilesPattern::c2bSearchInFilesPattern(QWidget* parent) : QWidget(parent)
{
    ui.setupUi(this);
    c2bBibParser* bp = c2b::bibParser();
    ui.patternScope->addItems(bp->bibFieldSortedList);
    ui.patternType->setCurrentIndex(c2bSettingsP->value("c2bSearchInFiles/PatternTypeIndex", 0).toInt());
    ui.yearScope->hide();
    ui.inputPattern->setFocus();

    connect(ui.clearB, SIGNAL(clicked()), this, SLOT(patternChanged()));
    connect(ui.inputPattern, SIGNAL(textEdited(const QString&)), this, SLOT(patternChanged()));
    connect(ui.patternScope, SIGNAL(currentIndexChanged(const QString&)), this, SLOT(showYearScope(const QString&)));
}

c2bSearchInFilesPattern::~c2bSearchInFilesPattern()
{
    c2bSettingsP->setValue("c2bSearchInFiles/PatternTypeIndex", ui.patternType->currentIndex());
}


void c2bSearchInFilesPattern::patternChanged()
{
    emit patternAvailable(isAvailable());
}

void c2bSearchInFilesPattern::setText(const QString& text)
{
    ui.inputPattern->setText(text);
    ui.inputPattern->setFocus();
}

void c2bSearchInFilesPattern::clear()
{
    ui.inputPattern->clear();
    ui.inputPattern->setFocus();
}

void c2bSearchInFilesPattern::setPattern(QTreeWidgetItem* newPattern)
{
    if (!newPattern)
        return;
    if (newPattern->columnCount() != ITEMS_IN_SEARCH_PATTERN)
        return;

    if (newPattern->text(0) == "NOT")
        ui.NOT->setChecked(true);
    else
        ui.NOT->setChecked(false);
    if (newPattern->text(1) == "Sensitive")
        ui.caseSensitive->setChecked(true);
    else
        ui.caseSensitive->setChecked(false);
    ui.patternType->setCurrentIndex(ui.patternType->findText(newPattern->text(2)));
    ui.patternScope->setCurrentIndex(ui.patternScope->findText(newPattern->text(3)));
    if (newPattern->text(4) == "=")
        ui.yearScope->setCurrentIndex(ui.yearScope->findText("Exact"));
    else if (newPattern->text(4) == ">")
        ui.yearScope->setCurrentIndex(ui.yearScope->findText("Newer"));
    else
        ui.yearScope->setCurrentIndex(ui.yearScope->findText("Older"));
    ui.inputPattern->setText(newPattern->text(5));
}

const QStringList c2bSearchInFilesPattern::pattern()
{
    QStringList _pattern;
    if (ui.NOT->isChecked())
        _pattern.append("NOT");
    else
        _pattern.append("");
    if (ui.caseSensitive->isChecked())
        _pattern.append("Sensitive");
    else
        _pattern.append("Insensitive");
    _pattern.append(ui.patternType->currentText());
    _pattern.append(ui.patternScope->currentText());
    if (ui.yearScope->isHidden())
        _pattern.append("");
    else
        if (ui.yearScope->currentText() == "Exact")
            _pattern.append("=");
        else if (ui.yearScope->currentText() == "Newer")
            _pattern.append(">");
        else if (ui.yearScope->currentText() == "Older")
            _pattern.append("<");
    _pattern.append(ui.inputPattern->text());
    return _pattern;
}

void c2bSearchInFilesPattern::showYearScope(const QString& scope)
{
    if (scope == "year")
        ui.yearScope->show();
    else
        ui.yearScope->hide();
}

void c2bSearchInFilesPattern::setFocus()
{
    ui.inputPattern->setFocus();
}
