/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bSearchPattern.h"

#include "c2bApproximatePattern.h"
#include "c2bWordPattern.h"


c2bSearchPattern::c2bSearchPattern(const QString& newPattern, const QString& newPatternType)
{
    pattern = newPattern;
    rx.setCaseSensitivity(Qt::CaseInsensitive);
    initType(newPatternType);
}

c2bSearchPattern::c2bSearchPattern(bool newNot, bool newCaseSensitive, const QString& newPatternType, const QString& newScope,
                                   const QString& newYearScope, const QString& newPattern)
{
    Not = newNot;
    pattern = newPattern;
    scope = newScope;
    yearScope = newYearScope;

    if (newCaseSensitive)
        rx.setCaseSensitivity(Qt::CaseSensitive);
    else
        rx.setCaseSensitivity(Qt::CaseInsensitive);
    initType(newPatternType);
    if (Not)
        _pattern_string += "NOT.";
    _pattern_string += QString(" [%1][%2|case=%3]").arg(pattern).arg(newPatternType).arg(newCaseSensitive);
    if (scope == "year")
        _pattern_string += QString(" IN [%1(%2)]").arg(scope).arg(yearScope);
    else
        _pattern_string += QString(" IN [%1]").arg(scope);

    // Set an approximate ranking to speed up composite searches
    _rank = 0;
    if (scope == "all" || scope == "file")
        _rank += 100;
    else if (scope == "year" || scope == "volume" || scope == "pages")
        _rank += 50;
    else
        _rank += 1;
    if (!newCaseSensitive)
        _rank *= 2;
    if (newPatternType == "Fixed string: All Words" || newPatternType == "Fixed string: Any Word")
        _rank *= 5;
    else if (newPatternType == "Approximate string")
        _rank *= 10;
}


void c2bSearchPattern::initType(const QString& type)
{
    if (type == "Approximate string")
    {
        c2bApproximatePattern ap(pattern, rx.caseSensitivity());
        rx = ap.toRegExp();
        subrx = ap.subpatterns();
        _match_any_subpattern = true;
    }
    else if (type == "Fixed string: All Words")
    {
        c2bWordPattern ap(pattern, rx.caseSensitivity());
        rx = ap.toRegExp();
        subrx = ap.subpatterns();
        _match_any_subpattern = false;
    }
    else if (type == "Fixed string: Any Word")
    {
        c2bWordPattern ap(pattern, rx.caseSensitivity());
        rx = ap.toRegExp();
        subrx = ap.subpatterns();
        _match_any_subpattern = true;
    }
    else
    {
        rx.setPattern(pattern);
        if (type == "Fixed string")
            rx.setPatternSyntax(QRegExp::FixedString);
        else if (type == "Regular Expresion")
            rx.setPatternSyntax(QRegExp::RegExp);
        else if (type == "Wildcard")
            rx.setPatternSyntax(QRegExp::Wildcard);
        rx.setMinimal(true);
    }
}
