/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BSETTINGS_H
#define C2BSETTINGS_H

#include "cb2Bib_par.h"
#include "c2bColors.h"

#include <QDir>
#include <QFont>
#include <QProgressBar>
#include <QSettings>
#include <QStringList>


class c2bSettings : public QSettings
{

    Q_OBJECT

public:
    c2bSettings(const QString& organization, const QString& application, QObject* parent = 0);
    c2bSettings(const QString& fn, QObject* parent = 0);
    ~c2bSettings();

    bool autostart_bibtex_editor;
    bool init_gui;
    c2bColors colors;
    QFont c2bMonoFont;
    QString fileName(const QString& key);
    QStringList bibTeXFilelist;
    QString tmp_dir_path;
    void notify();
    void setDefaultValue(const QString& key, const QVariant& value);
    void setFileName(const QString& key, const QString& fn);
    void update();
    static c2bSettings* instance()
    {
        Q_ASSERT_X(c2b_global_settings, "c2bSettings", "c2bSettings was not instantiated");
        return c2b_global_settings;
    }
    static bool confMode();
    static const QString confFileName();
    inline bool isUsbConfMode() const
    {
        return is_usbConfMode;
    }


signals:
    void newSettings();


private:
    bool is_cb2bib_running;
    bool is_usbConfMode;
    QDir qAppDir;
    QProgressBar progBar;
    QString tmp_imported_reference_file;
    static c2bSettings* c2b_global_settings;
    static void printUsage();
    void init();
    void processReferenceFile();
    void readCommandLine();
    void setDefaults();


private slots:
    void guiExits();
    void processReferenceFileEvent();

};

#define c2bSettingsP (static_cast<c2bSettings*>(c2bSettings::instance()))

#endif
