/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BTEXTEDIT_H
#define C2BTEXTEDIT_H

#include <QTextEdit>


class QAction;
class QMenu;


class c2bTextEdit : public QTextEdit
{
    Q_OBJECT
public:
    c2bTextEdit(QWidget* parent = 0);
    ~c2bTextEdit();

    QAction* convertSelection2LaTeXAction;
    QAction* convertSelection2UnicodeAction;
    QAction* journalsToAbbreviatedAction;
    QAction* journalsToFullAction;
    QAction* pasteCurrentBibTeXAction;
    QAction* updateMetadataAction;
    QAction* wordUnWrapAction;
    QAction* wordWrapAction;
    void setBibTeXActions();

    inline const QString editFileName() const
    {
        return edit_file_name;
    }

    void setEditFileName(const QString& fn)
    {
        edit_file_name = fn;
    }


signals:
    void overwriteModeChanged();


public slots:
    void updatePlainText(const QString& text);
    void wordUnWrap();
    void wordWrap();


protected slots:
    void convert2LaTeX();
    void convert2Unicode();


protected:
    void contextMenuEvent(QContextMenuEvent * e);
    void keyPressEvent(QKeyEvent * e);


private:
    QString edit_file_name;

};

#endif
