/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bWordPattern.h"
#include "c2bUtils.h"


c2bWordPattern::c2bWordPattern(const QString newPattern, Qt::CaseSensitivity newCs) : compositePattern(newPattern, newCs)
{
    setPattern();
}

c2bWordPattern::~c2bWordPattern()
{}


void c2bWordPattern::setPattern()
{
    QStringList patternPieces = pattern.split(QRegExp("\\W"), QString::SkipEmptyParts);
    if (patternPieces.count() < 2)
    {
        arx.setPattern(escape(pattern, caseSensitivity));
        return;
    }
    QStringList subPatterns;
    QRegExp _asrx;
    _asrx.setPatternSyntax(QRegExp::RegExp2);
    _asrx.setMinimal(false);
    _asrx.setCaseSensitivity(Qt::CaseSensitive);
    QMap<double, QRegExp> sort_asrx;
    for (int i = 0; i < patternPieces.count(); ++i)
    {
        QString sp = escape(patternPieces.at(i), caseSensitivity);
        subPatterns.append(sp);
        _asrx.setPattern(sp);
        // Sort according expectation (arXiv:0705.0751v1, Eq. 6)
        sort_asrx.insert(-probability(sp), _asrx);
    }
    asrx = sort_asrx.values();
    arx.setPattern(QString("(?:%1)").arg(subPatterns.join("|")));
}
