/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef CB2BIB_H
#define CB2BIB_H

#include "ui_cb2Bib.h"

#include <QHash>
#include <QMainWindow>
#include <QPointer>


class c2bBibHighlighter;
class c2bBibParser;
class c2bBibSearcher;
class c2bClipEdit;
class c2bClipboard;
class c2bConfigure;
class c2bEditor;
class c2bNetwork;
class c2bNetworkQuery;
class c2bPdfImport;
class c2bSearchInFiles;
class c2bSettings;
class c2bTextBrowser;


class cb2Bib : public QMainWindow
{

    Q_OBJECT

public:
    cb2Bib(QWidget* parent = 0);
    ~cb2Bib();


signals:
    void addedBibToFile(const QString&);
    void endedProcessing(bool status);


private:
    QAction* bib_menu_any_pattern_action;
    QHash<QString, c2bEditor*> openDocuments;
    QHash<QString, c2bLineEdit*> bibFields;
    QMenu* bib_menu;
    QPointer<c2bPdfImport> pdfImport;
    QPointer<c2bSearchInFiles> searchInFiles;
    QString m_dropped_article_file;
    QString m_target_article_file;
    QString raw_input_data;
    Ui::cb2Bib ui;
    bool m_connected;
    bool m_modified;
    bool taggedViewMode;
    c2bBibHighlighter* bibS;
    c2bBibParser* bp;
    c2bClipEdit* ClipEdit;
    c2bClipboard* cb;
    c2bNetworkQuery* netQ;
    c2bSettings* settings;
    c2bTextBrowser* AboutBrowser;
    c2bTextBrowser* BibBrowser;
    void closeEvent(QCloseEvent* ce);
    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);
    void fileDroppedByUser(const QString& fn);
    void initAsBibTeXEditor();
    void setBibMenu();
    void setBibWidgetMapping();
    void updateBibfile(const QString& fn);
    void updateViewButtons();


private slots:
    void abbreviationsEditor();
    void addAuthors();
    void addEditor();
    void addToFile(bool ready);
    void anyPattern();
    void bibEditor(const QString& bibtexfile, c2bBibSearcher* searcher = 0);
    void bibModified();
    void bookmarksEditor();
    void c2bInit();
    void dataChanged(const QString&);
    void deleteTmpBib();
    void doSearchInFiles(const QString& string = QString(), const QString& fn = QString());
    void fileDropped(const QString& fn);
    void forceDataChange(const QString&);
    void guessFields();
    void insertRegExp();
    void linkClicked(const QUrl& ln);
    void loadSettings();
    void makeNetQuery();
    void netQueryEnded(bool, const QString&, const QString&);
    void on_PdfImportB_clicked();
    void on_addBibB_clicked();
    void on_configureB_clicked();
    void on_connectB_clicked();
    void on_editBibTeXB_clicked();
    void on_exitB_clicked();
    void on_file_dirs_clicked();
    void on_makeNetworkQueryB_clicked();
    void on_searchInFilesB_clicked();
    void on_viewAboutB_clicked();
    void on_viewBibB_clicked();
    void openFileDocument();
    void postprocessBibTeX();
    void preParserEnded(const QString&);
    void preparseClipboard();
    void processingEnded();
    void readField();
    void regExpsEditor();
    void restartEngine();
    void savePattern(const QString&, const QString&);
    void selectFile();
    void setArticleFileName();
    void setTaggedClipEditMode(bool tagged);
    void showLink(const QString& ln);
    void showMessage(const QString& ms);
    void updateOpenDocuments(QObject* obj);
    void updateOpenDocuments(const QString& old_name, const QString& new_name);

};

#endif
