/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef CB2BIB_PAR_H
#define CB2BIB_PAR_H

#include <QString>

const int C2B_MESSAGE_TIME = 6000;
const QString C2B_APPLICATION = "cb2Bib";
const QString C2B_CITE_ID_PATTERN = "<<author_first>><<year_abbreviated>>";
#ifdef Q_WS_X11
const QString C2B_DATA_DIR = "/usr/share/cb2bib";
#endif
#ifdef Q_WS_MACX
const QString C2B_DATA_DIR = "Contents/Resources";
#endif
const QString C2B_FIND_REPLACE_LIST =
    "Corresponding Author Contact Information||ScienceDirect alt tag^e"
    "E-mail The Corresponding Author||ScienceDirect alt tag^e"
    "small pi, Greek|$\\pi$|ScienceDirect alt tag^e"
    "{sect}||PNAS - Author String^e"
    "{dagger}||PNAS - Author String";
const QString C2B_ICON_ABOUT_B_BACK = "back_cb2bib_32.png";
const QString C2B_ICON_ABOUT_B = "cb2bib.png";
const QString C2B_ICON_CONNECT_B = "connect_established.png";
const QString C2B_ICON_DIR = ":/icons/icons/";
const QString C2B_ICON_DISCONNECT_B = "connect_no.png";
const QString C2B_ICON_VIEWBIB_B = "viewbib.png";
const QString C2B_ICON_VIEWC2B_B = "viewcb.png";
const QString C2B_ORGANIZATION = "MOLspaces";
const QString C2B_VERSION = "1.0.4";

// File Manager Client
#ifdef Q_WS_X11
const QString C2B_FM_CLIENT_COPY_ARG = "copy";
const QString C2B_FM_CLIENT_COPY_BIN = "kfmclient";
const QString C2B_FM_CLIENT_MOVE_ARG = "move";
const QString C2B_FM_CLIENT_MOVE_BIN = "kfmclient";
const QString C2B_FM_CLIENT_OPEN_ARG = "exec";
const QString C2B_FM_CLIENT_OPEN_BIN = "kfmclient";
#endif
#ifdef Q_WS_MACX
const QString C2B_FM_CLIENT_COPY_ARG = "copy";
const QString C2B_FM_CLIENT_COPY_BIN = "kfmclient";
const QString C2B_FM_CLIENT_MOVE_ARG = "move";
const QString C2B_FM_CLIENT_MOVE_BIN = "kfmclient";
const QString C2B_FM_CLIENT_OPEN_ARG = "";
const QString C2B_FM_CLIENT_OPEN_BIN = "open";
#endif
#ifdef Q_WS_WIN
const QString C2B_FM_CLIENT_COPY_ARG = "";
const QString C2B_FM_CLIENT_COPY_BIN = "";
const QString C2B_FM_CLIENT_MOVE_ARG = "";
const QString C2B_FM_CLIENT_MOVE_BIN = "";
const QString C2B_FM_CLIENT_OPEN_ARG = "";
const QString C2B_FM_CLIENT_OPEN_BIN = "";
#endif

// to_text translator
#ifdef Q_WS_X11
const QString C2B_METAPREPARSER_EXIFTOOL_BIN = "/usr/bin/exiftool";
const QString C2B_BIBSEARCHER_PDF2TXT_BIN = "/usr/bin/pdftotext";
const QString C2B_PDFIMPORT_PDF2TXT_BIN = "/usr/bin/pdftotext";
#endif
#ifdef Q_WS_MACX
const QString C2B_METAPREPARSER_EXIFTOOL_BIN = "c2bExternTools/exiftool";
const QString C2B_BIBSEARCHER_PDF2TXT_BIN = "c2bExternTools/pdftotext";
const QString C2B_PDFIMPORT_PDF2TXT_BIN = "c2bExternTools/pdftotext";
#endif
#ifdef Q_WS_WIN
const QString C2B_METAPREPARSER_EXIFTOOL_BIN = "C:\\Windows\\exiftool.exe";
const QString C2B_PDFIMPORT_PDF2TXT_BIN = "C:\\Program Files\\xpdf-3.02-win32\\pdftotext.exe";
const QString C2B_BIBSEARCHER_PDF2TXT_BIN = "C:\\Program Files\\xpdf-3.02-win32\\pdftotext.exe";
#endif

// BibTeX postprocessing
#ifdef Q_WS_X11
const QString C2B_POSTPROCESS_BIBTEX_BIN = "c2btools/bib2pdf";
const QString C2B_POSTPROCESS_BIBTEX_ARG = "%finput %foutput";
const QString C2B_POSTPROCESS_BIBTEX_EXT = "bib.pdf";
#endif
#ifdef Q_WS_MACX
const QString C2B_POSTPROCESS_BIBTEX_BIN = "c2btools/bib2pdf";
const QString C2B_POSTPROCESS_BIBTEX_ARG = "%finput %foutput";
const QString C2B_POSTPROCESS_BIBTEX_EXT = "bib.pdf";
#endif
#ifdef Q_WS_WIN
const QString C2B_POSTPROCESS_BIBTEX_BIN = "";
const QString C2B_POSTPROCESS_BIBTEX_ARG = "%finput %foutput";
const QString C2B_POSTPROCESS_BIBTEX_EXT = "end";
#endif

#endif
