/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef COMPOSITEPATTERN_H
#define COMPOSITEPATTERN_H

#include <QRegExp>
#include <QStringList>


class compositePattern
{

public:
    compositePattern(const QString newPattern, Qt::CaseSensitivity newCs);
    virtual ~compositePattern();

    const QRegExp toRegExp() const
    {
        return arx;
    }

    const QList<QRegExp> subpatterns() const
    {
        return asrx;
    }


protected:
    QList<QRegExp> asrx;
    QRegExp arx;
    QString pattern;
    Qt::CaseSensitivity caseSensitivity;
    const QString escape(const QString& str, Qt::CaseSensitivity cs);
    double probability(const QString& str);

};

#endif
