/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 *   findDialog was originally adapted from Qt Designer
 *   Copyright (C) 2001 Trolltech AS.  All rights reserved.
 ***************************************************************************/
#include "findDialog.h"

#include <QPushButton>
#include <QScrollBar>
#include <QTextEdit>


findDialog::findDialog(QWidget* parent) : QDialog(parent)
{
    ui.setupUi(this);
    resize(size().width(), 1);
    ui.buttonBox->button(QDialogButtonBox::Ok)->setText(tr("Find"));
    _editor = qobject_cast<QTextEdit*>(parent);
    m_find_pattern = "";

    QAction* act = new QAction(this);
    act->setSeparator(true);
    addAction(act);
    findAction = new QAction(this);
    addAction(findAction);
    findAction->setShortcut(tr("Ctrl+F"));
    findAction->setText(tr("Find in Text"));
    findAction->setStatusTip(tr("Find in Text"));
    connect(findAction, SIGNAL(triggered()), this, SLOT(findText()));

    findNextAction = new QAction(this);
    addAction(findNextAction);
    findNextAction->setShortcut(tr("F3"));
    findNextAction->setText(tr("Find Next"));
    findNextAction->setStatusTip(tr("Find Next Occurrence"));
    connect(findNextAction, SIGNAL(triggered()), this, SLOT(findNext()));

    findPreviousAction = new QAction(this);
    addAction(findPreviousAction);
    findPreviousAction->setShortcut(tr("Shift+F3"));
    findPreviousAction->setText(tr("Find Previous"));
    findPreviousAction->setStatusTip(tr("Find Previous Occurrence"));
    connect(findPreviousAction, SIGNAL(triggered()), this, SLOT(findPrevious()));
}

findDialog::~findDialog()
{}


void findDialog::init()
{
    ui.notFound->hide();
    raise();
    ui.comboFind->setEditText(_editor->textCursor().selectedText().trimmed());
    ui.comboFind->setFocus();
}

void findDialog::setEditor(QTextEdit* editor)
{
    _editor = editor;
}

int findDialog::exec()
{
    if (!_editor)
        return (-1);
    init();
    return QDialog::exec();
}

void findDialog::show()
{
    if (!_editor)
        return;
    init();
    QDialog::show();
}

void findDialog::accept()
{
    if (ui.comboFind->currentText().isEmpty())
        return;
    if (_editor)
    {
        if (findText(ui.comboFind->currentText(), ui.radioForward->isChecked(),
                     ui.checkCase->isChecked(), ui.checkWords->isChecked()))
            QDialog::accept();
        else
            ui.notFound->show();
    }
}

void findDialog::findText()
{
    show();
}

bool findDialog::findText(const QString& pattern, bool forward, bool caseSensitive, bool wholeWords)
{
    if (pattern.isEmpty())
        return false;
    m_find_pattern = pattern;
    m_find_case = caseSensitive;
    m_find_words = wholeWords;

    QTextDocument *doc = _editor->document();
    QTextCursor c = _editor->textCursor();
    QTextDocument::FindFlags options;

    if (c.hasSelection())
        c.setPosition(forward ? c.position() : c.anchor(), QTextCursor::MoveAnchor);
    QTextCursor newCursor = c;
    if (!forward)
        options |= QTextDocument::FindBackward;
    if (m_find_case)
        options |= QTextDocument::FindCaseSensitively;
    if (m_find_words)
        options |= QTextDocument::FindWholeWords;
    newCursor = doc->find(m_find_pattern, c, options);
    bool found = true;
    if (newCursor.isNull())
    {
        QTextCursor ac(doc);
        ac.movePosition(options & QTextDocument::FindBackward ? QTextCursor::End : QTextCursor::Start);
        newCursor = doc->find(m_find_pattern, ac, options);
        if (newCursor.isNull())
        {
            newCursor = c;
            found = false;
        }
    }
    _editor->setTextCursor(newCursor);
    _editor->verticalScrollBar()->setValue(_editor->verticalScrollBar()->maximum());
    _editor->ensureCursorVisible();
    return found;
}

void findDialog::findNext()
{
    if (m_find_pattern.isEmpty())
        findText();
    else
        findText(m_find_pattern, true, m_find_case, m_find_words);
}

void findDialog::findPrevious()
{
    if (m_find_pattern.isEmpty())
        findText();
    else
        findText(m_find_pattern, false, m_find_case, m_find_words);
}
