/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/

#include <QApplication>

#include "c2bSettings.h"
#include "cb2Bib.h"


int main(int argc, char *argv[])
{
    Q_INIT_RESOURCE(cb2bib);

    QApplication app(argc, argv);
    app.setOrganizationName(C2B_ORGANIZATION);
    app.setApplicationName(C2B_APPLICATION);
#if QT_VERSION >= 0x040400
    // Avoid flickering
    app.setAttribute(Qt::AA_NativeWindows, true);
#endif

    if (c2bSettings::confMode())
    {
        c2bSettings settings(c2bSettings::confFileName());
        if (settings.init_gui)
        {
            cb2Bib c2B;
            if (!settings.autostart_bibtex_editor) c2B.show();
            return app.exec();
        }
        else
            return app.exec();
    }
    else
    {
        c2bSettings settings(C2B_ORGANIZATION, C2B_APPLICATION);
        if (settings.init_gui)
        {
            cb2Bib c2B;
            if (!settings.autostart_bibtex_editor) c2B.show();
            return app.exec();
        }
        else
            return app.exec();
    }
}
