/***************************************************************************
 *   Copyright (C) 2004-2008 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.0.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "monthDB.h"


monthDB::monthDB()
{
    QString month = "January|February|March|April|May|June|July|August|September|October|November|December";
    FullMonth = month.split("|");
    month = "jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec";
    AvMonth = month.split("|");
}

monthDB::~monthDB()
{
    FullMonth.clear();
    AvMonth.clear();
}


QString monthDB::retrieve(QString MQuery)
{
    QString Day = "";
    QRegExp day("(\\d+)");
    int ncap = day.indexIn(MQuery);
    if (ncap > -1)
    {
        Day = day.cap(1);
    }
    if (!Day.isEmpty())
        Day = QString(" # \"%1~\"").arg(Day.toInt());
    //     Day = QString("\"%1~\" # ").arg(Day.toInt());
    QString Month = "";
    QRegExp month("([A-Za-z]+)");
    ncap = month.indexIn(MQuery);
    if (ncap > -1)
    {
        Month = month.cap(1);
    }
    Month = abbreviate(Month);
    return (Month + Day);
    //     return ( Day + Month );
}

QString monthDB::abbreviate(QString MQuery)
{
    for (int i = 0; i < 12; i++)
    {
        if (FullMonth.at(i).contains(MQuery, Qt::CaseInsensitive))
            return(AvMonth.at(i));
    }
    return(MQuery);
}
