//
// C++ Implementation: expression
//
// Description:
//
//
// Author: Mike Arrison <arrison@graphcalc.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <iostream>
#include <sstream>
#include <fstream>
#include "expression.h"
using namespace std;
using namespace GiNaC;

expression::expression(QString in_expression)
{
    currentExpression = in_expression;
	x = symbol("x");
	y = symbol("y");
	r = symbol("r");
	t = symbol("t");
	//symbol r("r");
	//symbol t("t");
    digitsInResult = 10;
    Digits = digitsInResult;
	ginac_expression = ex(in_expression,lst(x,y,r,t));
}

expression::~expression()
{
	// no need to delete child widgets, Qt does it all for us, I think
}

/*
long double expression::evaluate_num(double value_x, double value_y)
{
	long double answer_numeric;
	try {
		symbol x("x");
		symbol y("y");
		ex three(currentExpression,lst(x,y));
		//cout << dflt << three << ":";
		three = three.subs(lst(x == value_x, y == value_y));
		//three = three.subs(y == value_y);
		//cout << dflt << three << " " << flush;
		if (is_a<numeric>(three)) {
			//numeric num = ex_to<numeric>(three);
			//answer_numeric = to_double(num);
			answer_numeric = ex_to<numeric>(three).to_double();
		} else {
			answer_numeric = 0; //big problem  (maybe UNDEFINED would be better?)
		}
	} catch (exception &p) {
		answer_numeric = 0;			// How do you say undefined better than this?
		//s << p.what() << endl;    //Better error handling needed here
	}
	return answer_numeric;
}*/

long double expression::evaluate_num(double value_x, double value_y)
{
	//cout << "2" << flush;
	long double answer_numeric;
	try {
		ex tmp = ginac_expression.subs(lst(x == value_x, y == value_y));
		if (is_a<numeric>(tmp)) {
			answer_numeric = ex_to<numeric>(tmp).to_double();
		} else {
			answer_numeric = 0; //big problem  (maybe UNDEFINED would be better?)
		}
	} catch (exception &p) {
		answer_numeric = 0;			// How do you say undefined better than this?
	}
	return answer_numeric;
}

long double expression::evaluate_num(double value)
{
// see the graphing functions graph2d::graph and graph3d::graph for the invocation of this badboy
// I really hope ginac is as simple as this function makes it seem.

	//cout << "1" << flush;
	long double answer_numeric;
	try {
		//symbol x("x");
		//ex three(currentExpression,lst(x));
		//three = three.subs(x == value);
		ex tmp = ginac_expression.subs(x == value);
		if (is_a<numeric>(tmp)) {
			//numeric num = ex_to<numeric>(three);
			//answer_numeric = to_double(num);
			answer_numeric = ex_to<numeric>(tmp).to_double();
		} else {
			answer_numeric = value; //big problem  (maybe UNDEFINED would be better?)
		}
	} catch (exception &p) {
		answer_numeric = 0;			// How do you say undefined better than this?
		//s << p.what() << endl;    //Better error handling needed here
	}
	return answer_numeric;
}

QString expression::evaluate()
{
// This evaluate is for the output section (non-graphing).  It returns a string for expressions
// that may not simply into a numeric
	//cout << "0" << flush;
	ostringstream s;
	try {
		//symbol x("x");
		ex two(currentExpression, lst(x));
		s << dflt << evalf(two);
	} catch (exception &p) {
		s << p.what() << endl;
	}
	QString answer = s.str();
	return answer;
}
