//
// C++ Interface: graph2d
//
// Description:
//
//
// Author: Mike Arrison <arrison@graphcalc.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GRAPH2D_H
#define GRAPH2D_H

#include <qframe.h>
#include <qpen.h>
#include <qcolor.h>
#include <qpixmap.h>
#include "expression.h"
#include "graph2doptions.h"

/**
@author Mike Arrison
*/
class graph2d : public QFrame
{
public:
	graph2d(QWidget* parent, const char* name);
	~graph2d();
	void graph();
	void clear();
	void zoomIn();
	void zoomOut();
	void zoomStandard();
	void zoomPrevious();
	graph2doptions* OptionsWindow;
	void mousePressEvent(QMouseEvent* me);
	void wheelEvent(QWheelEvent* we);
	void mouseMoveEvent(QMouseEvent* me);
	void mouseReleaseEvent(QMouseEvent* me);
	void keyPressEvent(QKeyEvent* ke);

private:
	QPen graphPen;
	QPixmap pixMap;
	bool resized;
	bool firstPaint;

	// Local copies of OptionsWindow vars
	QString prev_xmin, prev_xmax, prev_ymin, prev_ymax, prev_xscale, prev_yscale;
	double xmin, xmax, ymin, ymax, xscale, yscale;

	int coord_to_screen(char axis, double coord);
	void reinit();
	void storeZoom();

	double graph_x_step;
	int xPressed;
	int yPressed;
	int xCurrent;
	int yCurrent;
	bool mouse_drawing_box;

protected:
	void paintEvent(QPaintEvent* pe);
	void resizeEvent(QResizeEvent* re);

//access routines
public:
	QPixmap getPixmap() { return pixMap; }
	void setPixmap(QPixmap p) { pixMap = p; }
};

#endif
