//
// C++ Interface: graph3d
//
// Description: 
//
//
// Author: Mike Arrison <arrison@graphcalc.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
@author Mike Arrison
@contributor Charlie Hall
*/
#ifndef GRAPH3D_H
#define GRAPH3D_H

#include <qgl.h>
#include "graph3doptions.h"

class graph3d : public QGLWidget
{
	Q_OBJECT

protected:
	void initializeGL();
	void paintGL();
	void resizeGL(int w, int h);

public:
	graph3d( QWidget* parent, const char* name );
	~graph3d();
	void mousePressEvent(QMouseEvent* me);
	void wheelEvent(QWheelEvent* we);
	void mouseMoveEvent(QMouseEvent* me);
	void keyReleaseEvent(QKeyEvent* ke);
	void keyPressEvent(QKeyEvent* ke);
	graph3doptions* OptionsWindow;
	void reGraph();

	void zoomIn();
	void zoomOut();
	void zoomPrevious();
	void zoomStandard();


private:
	GLfloat xRot;
	GLfloat yRot;
	GLfloat zRot;
	GLfloat xTran;
	GLfloat yTran;
	GLfloat zTran;
	int xPressed;
	int yPressed;
	int xCurrent;
	int yCurrent;
	bool mouse_mode; //0 for Rotation, 1 for translation
	bool refresh_needed;
	bool modifier_shift;
	bool modifier_control;

	//graphing
	GLfloat m_x_min;
	GLfloat m_x_max;
	GLfloat m_y_min;
	GLfloat m_y_max;
	int m_x_interval;
	int m_y_interval;
	GLuint m_GLlist[6]; // One for each equation

	void setXRotation(int degrees);
	void setYRotation(int degrees);
	void setZRotation(int degrees);
	void drawLines();
	void resetInputs();
};

#endif
