/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//QT headers
#include <qregexp.h>

//Local headers
#include "service.h"
#include "bccodegenerator.h"

using namespace Global;

BCCodeGenerator::BCCodeGenerator(const Global::FunctionsCodeMap& fm, const Global::ConstantsMap& cm, QObject *parent, const char *name)
 : QObject(parent, name)
{
  m_fcm = fm;
  m_cm = cm;
}


BCCodeGenerator::~BCCodeGenerator()
{
}

/*!
    \fn BCCodeGenerator::formatResultString(QString&)
 */
void BCCodeGenerator::formatResultString(QString& result, QString& resultBuffer)
{
  resultBuffer.stripWhiteSpace();

  if(resultBuffer[0] == '\n') resultBuffer.remove(0,1);

  resultBuffer.remove("\\\n").
               remove(QRegExp("\\(standard_in\\)\\s*[0-9]*\\:"));
  resultBuffer.replace(QRegExp("\n\\s*\n|\\s*\n"),"\n");

  if(resultBuffer[0] == '.')
    resultBuffer = "0" + resultBuffer;

  resultBuffer.replace("+.","+0.")
              .replace("-.","-0.")
              .replace("\n.","\n0.");

  result = resultBuffer;
  resultBuffer = QString::null;
}

/*!
    \fn BCCodeGenerator::convertToBC( QString& expression, FunctionsCodeMap fm, ConstantsMap cm);
 */
/*void BCCodeGenerator::convertToBC(QString& expression, FunctionsCodeMap fm, ConstantsMap cm)
{
  
}*/
void BCCodeGenerator::convertToBC(QString& expression)
{
  int i = 1;
  FunctionsCodeMap::Iterator itf;
  QMap<QString, QString> k;
  for(itf = m_fcm.begin(); itf not_eq m_fcm.end(); ++itf)
    {
      QString funcName = itf.key(),
              placeHolderString = QString("$%1$").arg(i);
      Service::replaceAllSubstrings(expression,
                           funcName.length(),
                           funcName + "(",
                           placeHolderString);
      k[placeHolderString] = funcName;
      i++;
    }
  // Masking builtin-function names with the strings $1$, $2$, $3$ etc.
  QStringList list = QStringList::split(",","sin,cos,tan,atan,log,ln,exp,sqr,sqrt,pow,fact,percent,re,im,conj,arg,mod");
  QStringList::Iterator itl;
  for(itl = list.begin(); itl not_eq list.end(); ++itl)
    {
      QString funcName = (*itl),
              placeHolderString = QString("$%1$").arg(i);
      Service::replaceAllSubstrings(expression,
                           funcName.length(),
                           funcName+"(",
                           placeHolderString);
      k[placeHolderString] = funcName;
      i++;
    }
  // Masking builtin-keywords with the strings $1$, $2$, $3$ etc.
  list = QStringList::split(",","return,while,if,else,break,continue,limits,quit,warranty,auto,for,print,switch,case,repeat,length,read,scale");
  for(itl = list.begin(); itl not_eq list.end(); ++itl)
    {
      QString keyword = (*itl),
              placeHolderString = QString("$%1$").arg(i);
      Service::replaceAllSubstrings(expression,
                           keyword.length(),
                           keyword,
                           placeHolderString);
      k[placeHolderString] = keyword;
      i++;
    }
  // Replacing constants names with their numerical value
  QString expressionBeforeReplacing = QString::null;
  while(expressionBeforeReplacing not_eq expression)
    {
      expressionBeforeReplacing = expression;
      ConstantsMap::Iterator itc;
      for(itc = m_cm.begin(); itc not_eq m_cm.end(); ++itc)
        {
          QString key = itc.key(),
                  data = itc.data();
          while(m_cm.contains(data)) data = m_cm[data];
          Service::replaceAllSubstrings(expression, key.length(), key, data);
        }
     // if(expressionBeforeReplacing == expression) break;
    }

  // Restoring functions names
  QMap<QString,QString>::Iterator itk;
  for(itk = k.begin(); itk not_eq k.end(); ++itk)
    {
      QString placeHolderString = itk.key();
      int pos = expression.find(placeHolderString, 0);
      while (pos not_eq -1)
        {
           expression.replace(pos, placeHolderString.length(), itk.data());
           pos = expression.find(placeHolderString, pos);
        }
    }
}


/*!
    \fn BCCodeGenerator::convertToKalcoolus(QString& expression);
 */
void BCCodeGenerator::convertToKalcoolus(QString& expression)
{
  //does nothing for now
  Q_UNUSED(expression);
}

#include "bccodegenerator.moc"
