/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BCCODEGENERATOR_H
#define BCCODEGENERATOR_H

//Qt headers
#include <qobject.h>

//Local headers
#include "globaltypes.h"

/**
 * @short This class create the bc script used internally by kalcoolus
 * @author Emiliano Gulmini
 */
class BCCodeGenerator : public QObject
{
  Q_OBJECT

  Global::FunctionsCodeMap m_fcm;
  Global::ConstantsMap m_cm;

  public:
    BCCodeGenerator(const Global::FunctionsCodeMap& fm, const Global::ConstantsMap& cm, QObject *parent = 0, const char *name = 0);

    ~BCCodeGenerator();

    /**
      * Makes kalcoolus expressions readable from BC interpreter
      */
    void convertToBC(QString& expression);
    /**
     * Converts BC code to kalcoolus notations
     */
    void convertToKalcoolus(QString& expression);
    void formatResultString(QString& result, QString& resultBuffer);

};

#endif
