/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CODEGENERATOR_H
#define CODEGENERATOR_H

//QT Headers
#include <qobject.h>
class QString;
class QStringList;

//KDE Headers
class KProcess;

//Local Headers
#include "kalcoolusrc.h"
class Configuration;
#include "globaltypes.h"
class BCCodeGenerator;
class PythonCodeGenerator;

/**
 * @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */
class CodeGenerator : public QObject
{
  Q_OBJECT
  private://Attributes
    QString m_displayText,
            m_program,
            m_bcScriptFilePath,
            m_pythonScriptFilePath,
            m_resultBuffer;
    Configuration* m_configuration;
    Global::LanguagesMap m_languagesMap;
    Global::ConstantsMap m_constantsMap;
    int m_numberOfBCObjects;
    int m_pythonProgramLinesNumber;
    BCCodeGenerator* m_bcCodeGenerator;
    PythonCodeGenerator* m_pythonCodeGenerator;
  public:
    static QString Mode;

  public:
    CodeGenerator(const QString& text,
                  const Global::LanguagesMap& languages,
                  const Global::ConstantsMap& constantsMap,
                  Configuration* configuration);

    ~CodeGenerator();

  public:
    QString executeProgram(bool b);
  private://BC Methods
    /**
     * Creates the internal bc script 
     */
    void generateProgramBC();
    void getScriptErrorBC(KProcess* proc, char* s, int i);
    void getScriptOutputBC(KProcess* proc, char* s, int i);
    QString builtinBCFunctions();
  public:
    void executeProgramBC(QString& result);

  private:// Python Methods
    /**
     * Creates the internal Python script
     */
    void generateProgramPython();
    void getScriptErrorPython(KProcess* proc, char* s, int i);
    void getScriptOutputPython(KProcess* proc, char* s, int i);
    QString builtinPythonFunctions();
  public:
    void executeProgramPython(QString& result);

  private: //Service Methods
    void connectKProcess(KProcess* proc);
  private slots:
    void slotGetScriptError(KProcess* proc, char* s, int i);
    void slotGetScriptOutput(KProcess* proc, char* s, int i);
    void slotProcessExited(KProcess* proc);
};

#endif
