/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini                                *
 *   emi_barbarossa@yahoo.it                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//QT Headers
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qcolor.h>
#include <qcheckbox.h>

//KDE Headers
#include <kconfig.h>
#include <kurlrequester.h>
#include <kfontrequester.h>
#include <ktextedit.h>
#include <kcolorcombo.h>
#include <kpushbutton.h>

//Local Headers
#include "configuration.h"
#include "highlighter.h"

Configuration::Configuration(KConfig* config,
                             QMap<QString, KPushButton*> bMap,
                             KTextEdit* inEd,
                             KTextEdit* outEd,
                             KTextEdit* userFunEd,
                             QSpinBox* sc,
                             QSpinBox* ib,
                             QSpinBox* ob,
                             KURLRequester* kurlBC,
                             QSpinBox* dd,
                             KURLRequester* kurlPython,
                             KFontRequester* fr,
                             KColorCombo* num,
                             KColorCombo* op,
                             KColorCombo* fun,
                             KColorCombo* key,
                             KColorCombo* spec,
                             KURLRequester* logFile,
                             QCheckBox* enabledLog) : QObject()
{
  m_config = config;
  m_keyboardMap = bMap;
  m_inputDisplay = inEd;
  m_resultDisplay = outEd;
  m_editorUserFunctionBody = userFunEd;
  m_inputHighlighter = new Highlighter(m_inputDisplay);
  m_resultHighlighter = new Highlighter(m_resultDisplay);
  m_functionEditorHighlighter = new Highlighter(m_editorUserFunctionBody);
  //BC
  m_spbxScale = sc;
  m_spbxIBase = ib;
  m_spbxOBase = ob;
  m_kurlBCPath = kurlBC;

  connect(m_spbxScale, SIGNAL(valueChanged(const QString&)), this, SLOT(slotScale(const QString&)));
  connect(m_spbxIBase, SIGNAL(valueChanged(const QString&)), this, SLOT(slotIBase(const QString&)));
  connect(m_spbxOBase, SIGNAL(valueChanged(const QString&)), this, SLOT(slotOBase(const QString&)));

  //Python
  m_spbxPythonDecimalDigits = dd;
  m_kurlPythonModulesPath = kurlPython;

  connect(m_spbxPythonDecimalDigits, SIGNAL(valueChanged(const QString&)), this, SLOT(slotPythonDecimalDigits(const QString&)));

  //Fonts
  m_fontRequester = fr;
  m_colbxNumbers = num;
  m_colbxOperations = op;
  m_colbxFunctions = fun;
  m_colbxKeywords = key;
  m_colbxSpecials = spec;
  connect(m_fontRequester, SIGNAL(fontSelected(const QFont&)), this, SLOT(slotFontSelected(const QFont&)));
  connect(m_colbxNumbers, SIGNAL(activated(const QColor&)), this, SLOT(slotColorNumbers(const QColor&)));
  connect(m_colbxOperations, SIGNAL(activated(const QColor&)), this, SLOT(slotColorOperations(const QColor&)));
  connect(m_colbxFunctions, SIGNAL(activated(const QColor&)), this, SLOT(slotColorFunctions(const QColor&)));
  connect(m_colbxKeywords, SIGNAL(activated(const QColor&)), this, SLOT(slotColorKeywords(const QColor&)));
  connect(m_colbxSpecials, SIGNAL(activated(const QColor&)), this, SLOT(slotColorSpecial(const QColor&)));

  //Options
  m_kurlLogFilePath = logFile;
  m_cbxEnableLogFile = enabledLog;
  connect(m_cbxEnableLogFile, SIGNAL(toggled(bool)), this, SLOT(slotEnableLogFile(bool)));
}


Configuration::~Configuration()
{
  m_inputDisplay = 0;
  m_resultDisplay = 0;
  m_editorUserFunctionBody = 0;
  if(m_inputHighlighter) delete m_inputHighlighter;
  if(m_resultHighlighter) delete m_resultHighlighter;
  if(m_functionEditorHighlighter) delete m_functionEditorHighlighter;

  m_spbxScale = 0;
  m_spbxIBase = 0;
  m_spbxOBase = 0;
  m_kurlBCPath = 0;
  m_config = 0;
  //m_keyboardMap = 0;

  m_spbxPythonDecimalDigits = 0;
  m_kurlPythonModulesPath = 0;

  m_fontRequester = 0;
  m_colbxNumbers = 0;
  m_colbxOperations = 0;
  m_colbxFunctions = 0;
  m_colbxKeywords = 0;
  m_colbxSpecials = 0;

  m_kurlLogFilePath = 0;
  m_cbxEnableLogFile = 0;
}

/*!
    \fn Configuration::setNumberButtonsColor(const QColor& c)
 */
void Configuration::setNumberButtonsColor(const QColor& c)
{
  // Setting color for number buttons 
  m_keyboardMap["0"]->setPaletteBackgroundColor(c);
  m_keyboardMap["1"]->setPaletteBackgroundColor(c);
  m_keyboardMap["2"]->setPaletteBackgroundColor(c);
  m_keyboardMap["3"]->setPaletteBackgroundColor(c);
  m_keyboardMap["4"]->setPaletteBackgroundColor(c);
  m_keyboardMap["5"]->setPaletteBackgroundColor(c);
  m_keyboardMap["6"]->setPaletteBackgroundColor(c);
  m_keyboardMap["7"]->setPaletteBackgroundColor(c);
  m_keyboardMap["8"]->setPaletteBackgroundColor(c);
  m_keyboardMap["9"]->setPaletteBackgroundColor(c);
  m_keyboardMap["A"]->setPaletteBackgroundColor(c);
  m_keyboardMap["B"]->setPaletteBackgroundColor(c);
  m_keyboardMap["C"]->setPaletteBackgroundColor(c);
  m_keyboardMap["D"]->setPaletteBackgroundColor(c);
  m_keyboardMap["E"]->setPaletteBackgroundColor(c);
  m_keyboardMap["F"]->setPaletteBackgroundColor(c);
  m_keyboardMap["Im"]->setPaletteBackgroundColor(c);
}

/*!
    \fn Configuration::setOperationButtonsColor(const QColor& c)
 */
void Configuration::setOperationButtonsColor(const QColor& c)
{
  // Setting color for operation buttons 
  m_keyboardMap["+"]->setPaletteBackgroundColor(c);
  m_keyboardMap["*"]->setPaletteBackgroundColor(c);
  m_keyboardMap["/"]->setPaletteBackgroundColor(c);
  m_keyboardMap["-"]->setPaletteBackgroundColor(c);
  m_keyboardMap["="]->setPaletteBackgroundColor(c);
  m_keyboardMap["=="]->setPaletteBackgroundColor(c);
  m_keyboardMap["!="]->setPaletteBackgroundColor(c);
  m_keyboardMap[">"]->setPaletteBackgroundColor(c);
  m_keyboardMap[">="]->setPaletteBackgroundColor(c);
  m_keyboardMap["<"]->setPaletteBackgroundColor(c);
  m_keyboardMap["<="]->setPaletteBackgroundColor(c);
  m_keyboardMap["complex"]->setPaletteBackgroundColor(c);
  m_keyboardMap["last"]->setPaletteBackgroundColor(c);
  m_keyboardMap["newline"]->setPaletteBackgroundColor(c);
  m_keyboardMap["."]->setPaletteBackgroundColor(c);
  m_keyboardMap["("]->setPaletteBackgroundColor(c);
  m_keyboardMap[")"]->setPaletteBackgroundColor(c);
}

/*!
    \fn Configuration::setFunctionButtonsColor(const QColor& c)
 */
void Configuration::setFunctionButtonsColor(const QColor& c)
{
  // Setting color for function buttons 
  m_keyboardMap["sin"]->setPaletteBackgroundColor(c);
  m_keyboardMap["cos"]->setPaletteBackgroundColor(c);
  m_keyboardMap["tan"]->setPaletteBackgroundColor(c);
  m_keyboardMap["atan"]->setPaletteBackgroundColor(c);
  m_keyboardMap["log"]->setPaletteBackgroundColor(c);
  m_keyboardMap["ln"]->setPaletteBackgroundColor(c);
  m_keyboardMap["exp"]->setPaletteBackgroundColor(c);
  m_keyboardMap["sqr"]->setPaletteBackgroundColor(c);
  m_keyboardMap["sqrt"]->setPaletteBackgroundColor(c);
  m_keyboardMap["pow"]->setPaletteBackgroundColor(c);
  m_keyboardMap["fact"]->setPaletteBackgroundColor(c);
  m_keyboardMap["npr"]->setPaletteBackgroundColor(c);
  m_keyboardMap["nrr"]->setPaletteBackgroundColor(c);
  m_keyboardMap["binom"]->setPaletteBackgroundColor(c);
  m_keyboardMap["ncr"]->setPaletteBackgroundColor(c);
  m_keyboardMap["percent"]->setPaletteBackgroundColor(c);
  m_keyboardMap["real"]->setPaletteBackgroundColor(c);
  m_keyboardMap["imag"]->setPaletteBackgroundColor(c);
  m_keyboardMap["conj"]->setPaletteBackgroundColor(c);
  m_keyboardMap["arg"]->setPaletteBackgroundColor(c);
  m_keyboardMap["mod"]->setPaletteBackgroundColor(c);
}

/*!
    \fn Configuration::setKeywordButtonsColor(const QColor& c)
 */
void Configuration::setKeywordButtonsColor(const QColor& c)
{Q_UNUSED(c);
}

/*!
    \fn Configuration::setSpecialButtonsColor(const QColor& c)
 */
void Configuration::setSpecialButtonsColor(const QColor& c)
{
  // Setting color for special buttons
  m_keyboardMap["warn"]->setPaletteBackgroundColor(c);
  m_keyboardMap["bye"]->setPaletteBackgroundColor(c);
  m_keyboardMap["save"]->setPaletteBackgroundColor(c);
}



//BC Configuration
/*!
    \fn Configuration::loadBCSettings()
 */
void Configuration::loadBCSettings()
{
  // Loading from kalcoolusrc file to configuration object 
  m_config->setGroup("BC Settings");

  m_scale = m_config->readEntry("Scale",Resource::ScaleValue);
  m_ibase = m_config->readEntry("IBase",Resource::IBaseValue);
  m_obase = m_config->readEntry("OBase",Resource::OBaseValue);
  m_bcPath = m_config->readEntry("BC Path",Resource::BCPathValue);

  m_spbxScale->setValue(m_scale.toInt());
  m_spbxIBase->setValue(m_ibase.toInt());
  m_spbxOBase->setValue(m_obase.toInt());
  m_kurlBCPath->setKURL(m_bcPath);

  enableButtons();
}

/*!
    \fn void Configuration::saveBCSettings()
 */
void Configuration::saveBCSettings()
{
  // Writing GUI objects data to configuration object
  m_bcPath = m_kurlBCPath->url();
  m_scale.setNum(m_spbxScale->value());
  m_ibase.setNum(m_spbxIBase->value());
  m_obase.setNum(m_spbxOBase->value());
  // Writing configuration objects data to kalcoolusrc file 
  m_config->setGroup("BC Settings");
  m_config->writeEntry("Scale", m_scale);
  m_config->writeEntry("IBase", m_ibase);
  m_config->writeEntry("OBase", m_obase);
  m_config->writeEntry("BC Path", m_bcPath);
  m_config->sync();
}

/*!
    \fn void Configuration::enableButtons()
 */
void Configuration::enableButtons()
{
  // Enabling hexadecimal buttons when numerical base changes
  QStringList numButton = QStringList::split("","123456789ABCDEF");
  int i,
      inputBaseValue = m_ibase.toInt();
  for(i = 0; i < 15; i++)
    if(i <= (inputBaseValue-2))
       m_keyboardMap[numButton[i]]->setEnabled(true);
    else
      m_keyboardMap[numButton[i]]->setEnabled(false);
}

/*!
    \fn Configuration::slotScale(const QString& s)
 */
void Configuration::slotScale(const QString& s)
{
  m_scale = s;
}

/*!
    \fn Configuration::slotIBase(const QString& s)
 */
void Configuration::slotIBase(const QString& s)
{
  m_ibase = s;
  enableButtons();
}

/*!
    \fn Configuration::slotOBase(const QString& s)
 */
void Configuration::slotOBase(const QString& s)
{
  m_obase = s;
}

/*!
    \fn Configuration::slotColorNumbers(const QColor& c)
 */

void Configuration::setColorNumbers(const QColor& c)
{
  m_colorNumbers = QString::number(c.red(),10) + "," +
                   QString::number(c.green(),10) + "," +
                   QString::number(c.blue(),10);
}

/*!
    \fn Configuration::slotColorOperations(const QColor& c)
 */
void Configuration::setColorOperations(const QColor& c)
{
  m_colorOperations = QString::number(c.red(),10) + "," +
                      QString::number(c.green(),10) + "," +
                      QString::number(c.blue(),10);
}

/*!
    \fn Configuration::slotColorFunctions(const QColor& c)
 */
void Configuration::setColorFunctions(const QColor& c)
{
  m_colorFunctions = QString::number(c.red(),10) + "," +
                     QString::number(c.green(),10) + "," +
                     QString::number(c.blue(),10);
}

/*!
    \fn Configuration::slotColorKeywords(const QColor& c)
 */
void Configuration::setColorKeywords(const QColor& c)
{
  m_colorKeywords = QString::number(c.red(),10) + "," +
                    QString::number(c.green(),10) + "," +
                    QString::number(c.blue(),10);
}

/*!
    \fn Configuration::slotColorSpecials(const QColor& c)
 */
void Configuration::setColorSpecials(const QColor& c)
{
  m_colorSpecials = QString::number(c.red(),10) + "," +
                    QString::number(c.green(),10) + "," +
                    QString::number(c.blue(),10);
}


//Python Configuration
/*!
    \fn Configuration::loadPythonSettings()
 */
void Configuration::loadPythonSettings()
{
  // Loading from kalcoolusrc file to configuration object 
  m_config->setGroup("Python Settings");

  m_pythonDecimalDigits = m_config->readEntry("Python Decimal Digits", Resource::PythonDecimalDigitsValue);
  m_pythonModulesPath = m_config->readEntry("Python Modules Path", Resource::PythonModulesPathValue);

  // Loading from configuration object to GUI objects 
  m_kurlPythonModulesPath->setKURL(m_pythonModulesPath);
  m_spbxPythonDecimalDigits->setValue(m_pythonDecimalDigits.toInt());
}

/*!
    \fn Configuration::savePythonSettings()
 */
void Configuration::savePythonSettings()
{
  // Writing GUI objects data to configuration object
  m_pythonDecimalDigits.setNum(m_spbxPythonDecimalDigits->value());
  m_pythonModulesPath = m_kurlPythonModulesPath->url();
  // Writing configuration objects data to kalcoolusrc file 
  m_config->setGroup("Python Settings");
  m_config->writeEntry("Python Decimal Digits", m_pythonDecimalDigits);
  m_config->writeEntry("Python Modules Path", m_pythonModulesPath);
  m_config->sync();
}


/*!
    \fn Configuration::slotPythonDecimalDigits(const QString& s)
 */
void Configuration::slotPythonDecimalDigits(const QString& s)
{
  m_pythonDecimalDigits = s;
}

//Fonts
/*!
    \fn Configuration::loadFontSettings()
 */
void Configuration::loadFontSettings()
{
  // Loading from kalcoolusrc file to configuration object 
  m_config->setGroup("Font Settings");
  setFont(m_config->readEntry("Font",Resource::FontValue));

  // Loading values from configuration object to GUI objects 
  QFont f;
  f.fromString(font());

  // Setting font of the edit areas 
  m_fontRequester->setFont(f);
  m_inputDisplay->setFont(f);
  m_resultDisplay->setFont(f);
  m_editorUserFunctionBody->setFont(f);

  // Reading color attributes 
  QString colNumbers = m_config->readEntry("Numbers color", Resource::NumbersColor),
          colOperations = m_config->readEntry("Operations color", Resource::OperationsColor),
          colFunctions = m_config->readEntry("Functions color", Resource::FunctionsColor),
          colKeywords = m_config->readEntry("Keywords color", Resource::KeywordsColor),
          colSpecials = m_config->readEntry("Specials color", Resource::SpecialsColor);

  // Setting number colors 
  int r = colNumbers.section(",",0,0).toInt(),
      g = colNumbers.section(",",1,1).toInt(),
      b = colNumbers.section(",",2,2).toInt();
  QColor c(r,g,b);
  setColorNumbers(c);
  m_colbxNumbers->setColor(c);
  m_inputHighlighter->setColor(c,Global::numbers);
  m_resultHighlighter->setColor(c,Global::numbers);
  m_functionEditorHighlighter->setColor(c,Global::numbers);
  setNumberButtonsColor(c);

  // Setting number operation/operator colors 
  r = colOperations.section(",",0,0).toInt(),
  g = colOperations.section(",",1,1).toInt(),
  b = colOperations.section(",",2,2).toInt();
  c.setRgb(r,g,b);
  setColorOperations(c);
  m_colbxOperations->setColor(c);
  m_inputHighlighter->setColor(c,Global::operations);
  m_resultHighlighter->setColor(c,Global::operations);
  m_functionEditorHighlighter->setColor(c,Global::operations);
  setOperationButtonsColor(c);

  // Setting function name colors 
  r = colFunctions.section(",",0,0).toInt(),
  g = colFunctions.section(",",1,1).toInt(),
  b = colFunctions.section(",",2,2).toInt();
  c.setRgb(r,g,b);
  setColorFunctions(c);
  m_colbxFunctions->setColor(c);
  m_inputHighlighter->setColor(c,Global::functions);
  m_resultHighlighter->setColor(c,Global::functions);
  m_functionEditorHighlighter->setColor(c,Global::functions);
  setFunctionButtonsColor(c);

  // Setting keyword colors 
  r = colKeywords.section(",",0,0).toInt(),
  g = colKeywords.section(",",1,1).toInt(),
  b = colKeywords.section(",",2,2).toInt();
  c.setRgb(r,g,b);
  setColorKeywords(c);
  m_colbxKeywords->setColor(c);
  m_inputHighlighter->setColor(c, Global::keywords);
  m_resultHighlighter->setColor(c, Global::keywords);
  m_functionEditorHighlighter->setColor(c, Global::keywords);
  setKeywordButtonsColor(c);

  // Setting special colors 
  r = colSpecials.section(",",0,0).toInt(),
  g = colSpecials.section(",",1,1).toInt(),
  b = colSpecials.section(",",2,2).toInt();
  c.setRgb(r,g,b);
  setColorSpecials(c);
  m_colbxSpecials->setColor(c);
  m_inputHighlighter->setColor(c, Global::specials);
  m_resultHighlighter->setColor(c, Global::specials);
  m_functionEditorHighlighter->setColor(c, Global::specials);
  setSpecialButtonsColor(c);
}

/*!
    \fn Configuration::saveFontSettings()
 */
void Configuration::saveFontSettings()
{
  QString spinBoxValue;

  // Writing GUI objects data to configuration object 
  setFont(m_fontRequester->font().toString());

  // Writing configuration objects data to kalcoolusrc file 
  m_config->setGroup("Font Settings");
  m_config->writeEntry("Font", font());

  //qWarning("FONT=%s",font.latin1());
  m_config->writeEntry("Numbers color", colorNumbers());
  m_config->writeEntry("Operations color", colorOperations());
  m_config->writeEntry("Functions color", colorFunctions());
  m_config->writeEntry("Keywords color", colorKeywords());
  m_config->writeEntry("Specials color", colorSpecials());
  m_config->sync();
}


/*!
    \fn Configuration::slotFontSelected(const QFont& f)
 */
void Configuration::slotFontSelected(const QFont& f)
{
  m_inputDisplay->setFont(f);
  m_resultDisplay->setFont(f);
  m_editorUserFunctionBody->setFont(f);
}

/*!
    \fn Configuration::slotColorNumbers(const QColor& c)
 */
void Configuration::slotColorNumbers(const QColor& c)
{
  setColorNumbers(c);
  m_inputHighlighter->setColor(c, Global::numbers);
  m_resultHighlighter->setColor(c, Global::numbers);
  m_functionEditorHighlighter->setColor(c, Global::numbers);
  setNumberButtonsColor(c);
}

/*!
    \fn Configuration::slotColorOperations(const QColor& c)
 */
void Configuration::slotColorOperations(const QColor& c)
{
  setColorOperations(c);
  m_inputHighlighter->setColor(c, Global::operations);
  m_resultHighlighter->setColor(c, Global::operations);
  m_functionEditorHighlighter->setColor(c, Global::operations);
  setOperationButtonsColor(c);
}

/*!
    \fn Configuration::slotColorFunctions(const QColor& c)
 */
void Configuration::slotColorFunctions(const QColor& c)
{
  setColorFunctions(c);
  m_inputHighlighter->setColor(c, Global::functions);
  m_resultHighlighter->setColor(c, Global::functions);
  m_functionEditorHighlighter->setColor(c, Global::functions);
  setFunctionButtonsColor(c);
}

/*!
    \fn Configuration::slotColorKeywords(const QColor& c)
 */
void Configuration::slotColorKeywords(const QColor& c)
{
  setColorKeywords(c);
  m_inputHighlighter->setColor(c, Global::keywords);
  m_resultHighlighter->setColor(c, Global::keywords);
  m_functionEditorHighlighter->setColor(c, Global::keywords);
  setKeywordButtonsColor(c);
}

/*!
    \fn Configuration::slotColorSpecial(const QColor& c)
 */
void Configuration::slotColorSpecial(const QColor& c)
{
  setColorSpecials(c);
  m_inputHighlighter->setColor(c, Global::specials);
  m_resultHighlighter->setColor(c, Global::specials);
  m_functionEditorHighlighter->setColor(c, Global::specials);
  setSpecialButtonsColor(c);
}

//Options
/*!
    \fn Configuration::loadOptionsSettings()
 */
void Configuration::loadOptionsSettings()
{
  // Loading from kalcoolusrc file to configuration object 
  m_config->setGroup("Options Settings");
  bool isEnabled = isEnabledLogFile();
  logFileEnabled(m_config->readBoolEntry("Enable Log File", false));
  if(isEnabled) setLogFilePath(m_config->readEntry("Log File Path", Resource::LogFilePathValue));
  // Loading from configuration object to GUI objects 
  m_cbxEnableLogFile->setChecked(isEnabled);
  m_kurlLogFilePath->setKURL(logFilePath());
  m_kurlLogFilePath->setEnabled(isEnabled);
}

/*!
    \fn Configuration::saveOptionsSettings()
 */
void Configuration::saveOptionsSettings()
{
  // Writing GUI objects data to configuration object 
  logFileEnabled(m_cbxEnableLogFile->isChecked());
  setLogFilePath(m_kurlLogFilePath->url());
  // Writing configuration objects data to kalcoolusrc file 
  m_config->setGroup("Options Settings");
  bool isEnabled = isEnabledLogFile();
  m_config->writeEntry("Enable Log File", isEnabled);
  if(isEnabled) m_config->writeEntry("Log File Path", logFilePath());

  m_config->sync();
}

/*!
    \fn Configuration::logFileEnabled(bool checked)
 */
void Configuration::logFileEnabled(bool checked)
{
  m_enableLogFile = checked;
}

/*!
    \fn Configuration::setLogFilePath(const QString& path)
 */
void Configuration::setLogFilePath(const QString& path)
{
  m_logFilePath = path;
}

/*!
    \fn Configuration::slotEnableLogFile(bool b)
*/
void Configuration::slotEnableLogFile(bool b)
{
  m_kurlLogFilePath->setEnabled(b);
  logFileEnabled(b);
}
#include "configuration.moc"
