/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini                                *
 *   emi_barbarossa@yahoo.it                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIGURATION_H
#define CONFIGURATION_H

//QT Headers
#include <qobject.h>
#include <qstring.h>
class QColor;
class QSpinBox;
class QCheckBox;
#include <qmap.h>

//KDE Headers
class KConfig;
class KURLRequester;
class KTextEdit;
class KFontRequester;
class KColorCombo;
class KPushButton;
//Local Headers
#include "globaltypes.h"
#include "kalcoolusrc.h"
class Highlighter;

/**
 * @short This class handles settings in the configuration tab page
 * @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */
class Configuration : public QObject
{
  Q_OBJECT
  KConfig* m_config;
  QMap<QString,  KPushButton*> m_keyboardMap;
  KTextEdit* m_inputDisplay,
           * m_resultDisplay,
           * m_editorUserFunctionBody;
  Highlighter* m_inputHighlighter,
             * m_resultHighlighter,
             * m_functionEditorHighlighter;
  //BC
  QSpinBox* m_spbxScale,
          * m_spbxIBase,
          * m_spbxOBase;
  KURLRequester* m_kurlBCPath;
  QString m_scale,
          m_ibase,
          m_obase;
  QString m_bcPath;

  //Python
  QSpinBox* m_spbxPythonDecimalDigits;
  QString m_pythonModulesPath;
  QString m_pythonDecimalDigits;
  KURLRequester* m_kurlPythonModulesPath;
  //Fonts
  QString m_font;
  QString m_colorNumbers,
          m_colorOperations,
          m_colorFunctions,
          m_colorKeywords,
          m_colorSpecials;
  KFontRequester* m_fontRequester;
  KColorCombo* m_colbxNumbers,
             * m_colbxOperations,
             * m_colbxFunctions,
             * m_colbxKeywords,
             * m_colbxSpecials;
  //Options
  QString m_logFilePath;
  bool m_enableLogFile;
  KURLRequester* m_kurlLogFilePath;
  QCheckBox* m_cbxEnableLogFile;

  public:
    Configuration(KConfig* config,
                  QMap<QString, KPushButton*> bMap,
                  KTextEdit* inEd,
                  KTextEdit* outEd,
                  KTextEdit* userFunEd,
                  QSpinBox* sc,
                  QSpinBox* ib,
                  QSpinBox* ob,
                  KURLRequester* kurlBC,
                  QSpinBox* dd,
                  KURLRequester* kurlPython,
                  KFontRequester* fr,
                  KColorCombo* num, KColorCombo* op, KColorCombo* fun, KColorCombo* key, KColorCombo* spec,
                  KURLRequester* logFile,
                  QCheckBox* enabledLog);

    ~Configuration();
  public:
    void setNumberButtonsColor(const QColor& c);
    void setOperationButtonsColor(const QColor& c);
    void setFunctionButtonsColor(const QColor& c);
    void setKeywordButtonsColor(const QColor& c);
    void setSpecialButtonsColor(const QColor& c);
    //Bc configuration
    void loadBCSettings();
    void saveBCSettings();
    void enableButtons();
    QString scale() const { return m_scale; }
    void setScale(const QString& s) { m_scale = s; }

    QString ibase() const { return m_ibase; }
    void setIBase(const QString& s) { m_ibase = s; }

    QString obase() const { return m_obase; }
    void setOBase(const QString& s) { m_obase = s; }

    QString bcPath() const { return m_bcPath; }
    void setBCPath(const QString& path) { m_bcPath = path; }
  private slots:
    void slotScale(const QString& s);
    void slotIBase(const QString& s);
    void slotOBase(const QString& s);

  public:
    //Fonts
    void loadFontSettings();
    void saveFontSettings();
    QString font() const { return m_font; }
    void setFont(const QString& f) { m_font = f; }

    QString colorNumbers() const { return m_colorNumbers; }
    void setColorNumbers(const QColor& c);

    QString colorOperations() const { return m_colorOperations; }
    void setColorOperations(const QColor& c);

    QString colorFunctions() const { return m_colorFunctions; }
    void setColorFunctions(const QColor& c);

    QString colorKeywords() const { return m_colorKeywords; }
    void setColorKeywords(const QColor& c);

    QString colorSpecials() const { return m_colorSpecials; }
    void setColorSpecials(const QColor& c);
  private slots:
    void slotFontSelected(const QFont& f);
    void slotColorNumbers(const QColor& c);
    void slotColorOperations(const QColor& c);
    void slotColorFunctions(const QColor& c);
    void slotColorKeywords(const QColor& c);
    void slotColorSpecial(const QColor& c);

  public:
    //Python
    void loadPythonSettings();
    void savePythonSettings();
    QString pythonModulesPath() const { return m_pythonModulesPath; }
    void setPythonModulesPath(const QString& path) { m_pythonModulesPath = path; }

    QString pythonDecimalDigits() const { return m_pythonDecimalDigits; }
    void setPythonDecimalDigits(const QString& s) { m_pythonDecimalDigits = s; }
  private slots:
    void slotPythonDecimalDigits(const QString& s);

  public:
    //Options
    void loadOptionsSettings();
    void saveOptionsSettings();
   // void saveLogFile();
    bool isEnabledLogFile() const { return m_enableLogFile; }
    void logFileEnabled(bool checked);

    QString logFilePath() const { return m_logFilePath; }
    void setLogFilePath(const QString& path);
  private slots:
    void slotEnableLogFile(bool b);

};

#endif
