/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONSTANTSDB_H
#define CONSTANTSDB_H

//Qt Headers
#include <qobject.h>
class QString;

//KDE Headers
class KListView;
class QListViewItem;
class KConfig;
class KLineEdit;
class KPushButton;
class KComboBox;
class KTextEdit;

//Local Headers
#include "globaltypes.h"

/**
 * @short This class is the database of the user defined constants
 * @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */
class ConstantsDB : public QObject
{
  Q_OBJECT
  private:
    QString m_constantsDatabasePath;
    Global::ConstantsMap m_constantsMap;
    KListView* m_constantsListview;
    KConfig* m_config;
    KLineEdit* m_leConstName,
             * m_leConstValue;
    KPushButton* m_bConstAdd,
               * m_bConstClear;
    KComboBox* m_cbxConstantsBox;
    KTextEdit* m_inputDisplay;

  public:
    ConstantsDB(KConfig* config, KListView* list, KLineEdit* name, KLineEdit* value, KPushButton* add, KPushButton* del, KComboBox* cBox, KTextEdit* display );

    ~ConstantsDB();

    void loadDatabase();
    void writeToDatabase();
    Global::ConstantsMap constantsDB() const { return m_constantsMap; }
  private:
    void loadConstantsIntoBox();
  private slots:
    void slotAddConstant();
    void slotClearConstant();
    void slotConstSelected(QListViewItem* item);
    void slotConstantsBox(const QString & s);
};

#endif
