/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FUNCTIONSDB_H
#define FUNCTIONSDB_H

//QT Headers
class QObject;
class QString;
#include <qmap.h>
class QDomDocument;

//KDE Headers
class KConfig;
class KPushButton;
class KComboBox;
class KLineEdit;
class KTextEditor;
//Local Headers
#include "globaltypes.h"
class BCCodeGenerator;
class PythonCodeGenerator;


/**
 * @short This class handles creation of user defined functions
 * @author Emiliano Gulmini<emi_barbarossa@yahoo.it>
 */
class FunctionsDB : QObject
{
  Q_OBJECT
  QString m_functionsDatabasePath;
  Global::LanguagesMap m_languagesMap;
  bool m_complexModeOn;
  KLineEdit* m_leUserFunctionName,
           * m_leUserFunctionArguments;
  KTextEdit* m_editorUserFunctionBody;
  KComboBox* m_cbxUserFunctionsList,
           * m_cbxFunctionsBox;
  KPushButton* m_bAddUserFunction,
             * m_bDeleteUserFunction;
  KConfig* m_config;
  KPushButton* m_bComplex;
  KTextEdit* m_inputDisplay;
  BCCodeGenerator* m_bc;
  PythonCodeGenerator* m_python;
  public:
    FunctionsDB(KConfig* config, KPushButton* complex,  KTextEdit* d, KLineEdit* name, KLineEdit* arguments, KTextEdit* body, KComboBox* list, KComboBox* fBox, KPushButton* add, KPushButton* del);

    ~FunctionsDB();
    /** reads the xml database of the user-defined functions */
    void loadDatabase();
    void loadFunctionsIntoBoxes();
    /** creates a xml database containing the user-defined functions */
    void writeToDatabase();
    /** creates a xml database for user-defined BC functions */
    void putBCIntoDatabase(QDomDocument& db);
    /** creates a xml database for user-defined Python functions */
    void putPythonIntoDatabase(QDomDocument& db);
    Global::LanguagesMap functionsDB() const { return m_languagesMap; }
    void getCodeGenerators(BCCodeGenerator* bc, PythonCodeGenerator* python);

  private:
    /** loads functions from database */
    void getCode(const QDomDocument& db);

  private slots:
    void slotAddUserFunction();
    void slotDeleteUserFunction();
    void slotEditUserFunction(int index);
    void slotSelectUserFunction(const QString& s);
};

#endif
