/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//QT Headers
#include <qtextedit.h>
#include <qregexp.h>

//KDE Headers

//Local Headers
#include "highlighter.h"

using namespace Global;

Highlighter::Highlighter(QTextEdit* t) : QSyntaxHighlighter(t)
{
}


Highlighter::~Highlighter()
{
}

/*!
    \fn Highlighter::setColor(const QColor& c, QString o)
 */
void Highlighter::setColor(const QColor& c, ColorType o) 
{
  switch(o)
    {
      case numbers: m_numbers = c; break;
      case operations: m_operations = c; break;
      case functions: m_functions = c; break;
      case keywords: m_keywords = c; break;
      case specials: m_specials = c; break;
    }
}
/*!
    \fn Highlighter::highlightParagraph(const QString & text, int endStateOfLastPara)
 */
int Highlighter::highlightParagraph(const QString & text, int endStateOfLastPara)
{
  endStateOfLastPara = 0;

  setFormat(0 , text.length(), QColor(0, 0, 0));

  QRegExp exp("[0123456789ABCDEF]+");
  int pos = 0;
  pos = exp.search(text, pos);

  while(pos > -1)
    {
      uint mlength = exp.matchedLength();
      setFormat(pos, mlength, m_numbers);
      pos = exp.search(text, pos+mlength);
    }

  QRegExp exp1("[\\*/\\+\\-%<>=!]+");
  pos = 0;
  pos = exp1.search(text, pos);

  while(pos > -1)
    {
      uint mlength = exp1.matchedLength();
      setFormat(pos, mlength, m_operations);
      pos = exp1.search(text, pos+mlength);
    }
  QRegExp exp2("[a-z]+");
  pos = 0;
  pos = exp2.search(text, pos);

  while(pos > -1)
    {
      uint mlength = exp2.matchedLength();
      setFormat(pos, mlength, m_functions);
      pos = exp2.search(text, pos+mlength);
    }
  QRegExp exp3("if|else|while|for|break|continue|halt|return|print|and|elif|continue|lambda|or|pass");
  pos = 0;
  pos = exp3.search(text, pos);

  while(pos > -1)
    {
      uint mlength = exp3.matchedLength();
      setFormat(pos, mlength, m_keywords);
      pos = exp3.search(text, pos+mlength);
    }
  return endStateOfLastPara;
}

