/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef HIGHLIGHTER_H
#define HIGHLIGHTER_H

//QT Headers
#include <qsyntaxhighlighter.h>
class QTextEdit;
class QString;
class QColor;

//KDE Headers

//Local Headers
#include <globaltypes.h>

/**
 * @short This is the syntax highlighter
 * @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */
class Highlighter : public QSyntaxHighlighter
{
    QColor m_numbers,
           m_operations,
           m_functions,
           m_keywords,
           m_specials;
  public:
    Highlighter(QTextEdit* t);

    ~Highlighter();

    int highlightParagraph(const QString & text, int endStateOfLastPara);
    void setColor(const QColor& c, Global::ColorType o);
};

#endif
