/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KALCOOLUS_H_
#define _KALCOOLUS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//QT Headers
class QFile;
class QFont;
class QColor;
class QPopupMenu;

//KDE Headers
class KConfig;
class KProcess;

//Local Headers
#include "kbc.h"
class Matrix;
class ConstantsDB;
class FunctionsDB;
class Configuration;
class Keyboard;
class Utilities;
class KalcoolusImplementIf;
class BCCodeGenerator;
class PythonCodeGenerator;
#include "globaltypes.h"
/**
 * @short Application Main Window
 * @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 * @version 0.2.a.1
 */
class Kalcoolus : public Kbc
{
    Q_OBJECT
public:
  /**
    * Default Constructor
    */
  Kalcoolus();

  /**
   * Default Destructor
   */
  virtual ~Kalcoolus();

private:
  QString m_inputBuffer,
          m_resultBuffer,
          m_last;
  Keyboard* m_keyboard;
  Global::LanguagesMap m_languagesMap;
  QMap<QString, QString> m_buttonsMap;
  KConfig* m_config;
  QString m_functionsDatabasePath;
  QString m_program,
          m_bcScriptFilePath,
          m_pythonScriptFilePath;
  ConstantsDB* m_constantsDB;
  FunctionsDB* m_functionsDB;
  Configuration* m_configuration;
  Utilities* m_utilities;

  KalcoolusImplementIf* m_interface;
  BCCodeGenerator* m_bcCodeGenerator;
  PythonCodeGenerator* m_pythonCodeGenerator;
  QPopupMenu* m_menu;
private:
  int min(int a, int b) { return (a < b ? a : b); }
  /** Groups the connect() in the contructor */
  void ConnectKeyboardPage();
  void ConnectConstantsPage();
  void ConnectFunctionsPage();
  void ConnectUtilitiesPage();
  void ConnectConfigurationPage();
  /** Maps keyboard buttons */
  void mapButtons();
  /** Reading/writing constants tab page */
  /** Reading/writing functions tab page */
  /** Creates help */
  void createHelp();
  /** Wraps functions */
  void insertStringIntoDisplay(const QString& s, int dpara, int dindex);
private slots:
  /** Keyboard page */
  void slotSave();
  void slotBye();
  void slotEqualClicked();
  void slotLastResultButton();
  void slotEraseClicked();
  void slotCancelClicked();
  void slotCopyrights();
  void slotComplexMode();
  /** Constants page */
  /** Functions page */

  /** Utilities page */
  void slotChooseUtilitiesItem(QIconViewItem* item);
  void slotUtilitiesPageSelected(QWidget* p);
  /*
  void slotApplyFunctionToMatrix();
  void slotNewMatrixButton();
  void slotAddToWorkspace(const Matrix&);
  void slotPopupMenu(QIconViewItem*, const QPoint&);*/
  //void slotFactorize
  /** Configuration page */
  void slotChooseConfigurationItem(QIconViewItem* item);
  void slotConfigurationPageSelected(QWidget* p);
  /** others */
  void slotHelp();
  void slotGetScriptError(KProcess* proc, char* s, int i);
  void slotGetScriptOutput(KProcess* proc, char* s, int i);
  void slotProcessExited(KProcess* proc);
};

#endif // _KALCOOLUS_H_
