/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//KDE
#include <ktextedit.h>
#include <kpushbutton.h>
//Local
#include "kalcoolusimplementif.h"

KalcoolusImplementIf::KalcoolusImplementIf(KTextEdit* inputDisplay, KTextEdit* outputDisplay, KPushButton* equalButton)
 :  DCOPObject("KalcoolusIf"), QObject()
{
  m_inputDisplay = inputDisplay;
  m_outputDisplay = outputDisplay;
  m_equalButton = equalButton;
  connect(this, SIGNAL(equalButtonClicked()), m_equalButton, SIGNAL(clicked()));
}

KalcoolusImplementIf::~KalcoolusImplementIf()
{
  m_inputDisplay = 0L;
  m_outputDisplay = 0L;
}

void KalcoolusImplementIf::enterData(const QString& s)
{
  int para,
      index;
  m_inputDisplay->getCursorPosition(&para,&index);

  uint i = 0,
       l = s.length();
  while(i < l)
    {
      if(s[i] == '\n') 
        {
          m_inputDisplay->insertAt("\n", para, index);
          para++;
          index = 0;
        }
      else
        m_inputDisplay->insertAt(s[i], para, index++);

      i++;
    }
   m_inputDisplay->setCursorPosition(para, index+i+1);
}

QString KalcoolusImplementIf::getResults()
{
  emit equalButtonClicked();
  return m_outputDisplay->text();
}

QString KalcoolusImplementIf::help(const QString& s)
{
  if(s == "all")
    return QString("- enterData <arg> : get data from command line and put them into the input display of Kalcoolus.\n- getResults : execs expressions you previously entered and prints the result to standard output.\n- help [arg] : this help. The arg arguments are :  all - shows all about Kalcoolus DCOP methods.\n  ");
  else return QString::null;
}
#include "kalcoolusimplementif.moc"
