/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KALCOOLUSIMPLEMENTIF_H
#define KALCOOLUSIMPLEMENTIF_H
//QT
#include <qobject.h>
//KDE
class KTextEdit;
class KPushButton;
//Local
#include <KalcoolusIf.h>

/**
 * Implements interfaces
 * @author Emiliano Gulmini
 */
class KalcoolusImplementIf : public QObject, virtual public KalcoolusIf
{
  Q_OBJECT
  private:
    KTextEdit* m_inputDisplay,
             * m_outputDisplay;
    KPushButton* m_equalButton;
  public:
    KalcoolusImplementIf(KTextEdit*, KTextEdit*, KPushButton* );

    ~KalcoolusImplementIf();
    void enterData(const QString& s);
    QString getResults();
    QString help(const QString& s);
  signals:
    void equalButtonClicked();

};

#endif
