/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qspinbox.h>
#include <kpushbutton.h>
#include "kalcoolusmatrixeditor.h"

int KalcoolusMatrixEditor::ID = 1;

KalcoolusMatrixEditor::KalcoolusMatrixEditor(Matrix* m)
 : MatrixEditor()
{
  m_matrix = m;
  m_matrix->init(1,1,"",QStringList());

  connect(m_spbxMatrixRows, SIGNAL(valueChanged(int)), this, SLOT(setNumRows(int)));
  connect(m_spbxMatrixCols, SIGNAL(valueChanged(int)), this, SLOT(setNumCols(int)));
  connect(m_bOkMatrix, SIGNAL(clicked()), this, SLOT(ok()));
  connect(m_bCancelMatrix, SIGNAL(clicked()), this, SLOT(cancel()));
}


KalcoolusMatrixEditor::~KalcoolusMatrixEditor()
{
  m_matrix = 0;
}

void KalcoolusMatrixEditor::ok()
{
  m_matrix->name = m_leMatrixName->text();

  if(m_matrix->name.isEmpty())
    {
      m_matrix->name = "Matrix_"+QString::number(ID);
      ID += 1;
    }

  QStringList m;
  int k = 0;
  for(int r = 0; r < m_matrix->rows; r++)
    for(int c = 0; c < m_matrix->cols; c++)
      m[k++] = m_tblMatrix->text(r,c);

  m_matrix->populateMatrix(m);

  accept();
}
#include "kalcoolusmatrixeditor.moc"


