/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KALCOOLUSMATRIXEDITOR_H
#define KALCOOLUSMATRIXEDITOR_H

#include <qtable.h>
#include <qlineedit.h>

#include "matrix.h"
#include "matrix_editor.h"

/**
 * @short Implemets the matrix editor
   @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */
class KalcoolusMatrixEditor : public MatrixEditor
{
  Q_OBJECT
  Matrix* m_matrix;
  static int ID;
  public:
    //KalcoolusMatrixEditor();
    KalcoolusMatrixEditor(Matrix* m);

    ~KalcoolusMatrixEditor();
  public:
    //Matrix matrix() const { return m_matrix; }
  private slots:
    void setNumRows(int r) { m_tblMatrix->setNumRows(r); m_matrix->rows = r; }
    void setNumCols(int c) { m_tblMatrix->setNumCols(c); m_matrix->cols = c; }
    void setName(const QString& s) { m_leMatrixName->setText(s); m_matrix->name = s; }
    void ok();
    void cancel() { reject(); }
};

#endif
