/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KALCOOLUSRC_H
#define KALCOOLUSRC_H

#include <qstring.h>

namespace Resource
{
/** Some constants */
const QString ScaleValue = "2";
const QString IBaseValue = "10";
const QString OBaseValue = "10";
const QString BCPathValue = "/usr/bin/bc";
const QString PythonModulesPathValue = "";
const QString PythonDecimalDigitsValue = "3";
const QString FontValue = "Arial,14,-1,5,75,0,0,0,0,0";
const QString LogFilePathValue = "";
const QString NumbersColor = "104,189,242";
const QString OperationsColor = "192,133,133";
const QString FunctionsColor = "167,192,137";
const QString KeywordsColor = "223,118,73";
const QString SpecialsColor = "248,240,158";
const QString PI = "3.141592653589793";

/** bc program default functions */
const QString BCDefaultFunctions =
                "define fact (x) {\n"
                "       if (x == 0 || x == 1) return (1);\n"
                "       if (x == 2) return 2;\n"
                "       a = x;\n"
                "       while(x > 2){\n"
                "         x -= 1;\n"
                "         a = a * x;}\n"
                "       return (a);\n"
                "}\n"
                "define npr (n,k) {\n"
                "       if (k == 1) return n;\n"
                "       a = n;\n"
                "       while(k > 1){\n"
                "         n -= 1;\n"
                "         a *= n;\n"
                "         k -=1;}\n"
                "       return (a);\n"
                "}\n"
                "define nrr (n,k) {\n"
                "       return (n^k);\n"
                "}\n"
                "define ncr (n,k) {\n"
                "       return (fact(n)/(fact(k)*fact(n-k)));\n"
                "}\n"
                "define tn (a,b,n) {\n"
                "       if(n == 0) return 1;\n"
                "       if(n == 1) return (a+b);\n"
                "       k = 0;\n"
                "       x = 0;\n"
                "       while (k <= n){\n"
                "         x += ncr(n,k)*(a^(n-k))*(b^k);\n"
                "         k += 1;}\n"
                "       return x;\n"
                "}\n"
                "define tan (x) {\n"
                "       return (s(x)/c(x));\n"
                "}\n"
                "define atan (x) {\n"
                "       return (a(x));\n"
                "}\n"
                "define log (x) {\n"
                "       return (l(x)/l(10));\n"
                "}\n"
                "define sqr (x) {\n"
                "       return (x^2);\n"
                "}\n"
                "define pow (x,y) {\n"
                "       return (x^y);\n"
                "}\n"
                "define sin (x) {\n"
                "       return (s(x));\n"
                "}\n"
                "define cos (x) {\n"
                "       return (c(x));\n"
                "}\n"
                "define ln (x) {\n"
                "       return (l(x));\n"
                "}\n"
                "define exp (x) {\n"
                "       return (e(x));\n"
                "}\n"
                "define percent (x,y) {\n"
                "       return ((x*y)/100);\n"
                "}\n\n";

/** python program default functions */
const QString PythonDefaultFunctions = "def fact (x):\n" 
                                       "\tif x <= 1: return 1\n"
                                       "\tif x == 2: return 2\n"
                                       "\ta = x\n"
                                       "\twhile x > 2:\n"
                                       "\t\tx -= 1\n"
                                       "\t\ta *= x\n"
                                       "\treturn a\n\n"
                                       "def tan (x):\n"
                                       "\treturn cmath.tan(x)\n\n"
                                       "def atan (x):\n"
                                       "\treturn cmath.atan(x)\n\n"
                                       "def log (x):\n"
                                       "\treturn cmath.log(x,10)\n\n"
                                       "def sqr (x):\n"
                                       "\treturn x**2\n\n"
                                       "def sqrt (x):\n"
                                       "\treturn cmath.sqrt(x)\n\n"
                                       "def sin (x):\n"
                                       "\treturn cmath.sin(x)\n\n"
                                       "def cos (x):\n"
                                       "\treturn cmath.cos(x)\n\n"
                                       "def log (x):\n"
                                       "\treturn cmath.log(x)/cmath.log(10)\n\n"
                                       "def ln (x):\n"
                                       "\treturn cmath.log(x)\n\n"
                                       "def exp (x):\n"
                                       "\treturn cmath.exp(x)\n\n"
                                       "def re (x):\n"
                                       "\treturn complex(x).real\n\n"
                                       "def im (x):\n"
                                       "\tq=x+0j\n"
                                       "\tr=q.real\n"
                                       "\treturn (-1j*(q-r))\n\n"
                                       "def mod (x):\n"
                                       "\tq=x+0j\n"
                                       "\tq=(q.real**2)-(q-q.real)**2\n"
                                       "\treturn abs(cmath.sqrt(q))\n\n"
                                       "def arg (x):\n"
                                       "\tq=x+0j\n"
                                       "\treal=q.real\n"
                                       "\timag=(-1j*(q-q.real)).real\n"
                                       "\tif real == 0 and imag > 0:\n"
                                       "\t\treturn cmath.pi/2\n"
                                       "\telif real == 0 and imag < 0:\n"
                                       "\t\treturn -cmath.pi/2\n"
                                       "\telif real > 0:\n"
                                       "\t\treturn math.atan2(imag,real)\n"
                                       "\telif real < 0 and imag > 0:\n"
                                       "\t\treturn cmath.pi+math.atan2(imag,real)\n"
                                       "\telse:\n"
                                       "\t\treturn math.atan2(imag,real)-cmath.pi\n\n"
                                       "def conj (x):\n"
                                       "\tq=x+0j\n"
                                       "\tq=q.real-(q-q.real)\n"
                                       "\treturn q\n\n"
                                       "def npr (n,k):\n"
                                       "\tif k == 1: return n\n"
                                       "\ta = n\n"
                                       "\twhile k > 1:\n"
                                       "\t\tn-= 1\n"
                                       "\t\ta *= n\n"
                                       "\t\tk -= 1\n"
                                       "\treturn a\n\n"
                                       "def nrr (n,k):\n"
                                       "\treturn (n**k)\n\n"
                                       "def ncr (n,k):\n"
                                       "\treturn (fact(n)/(fact(k)*fact(n-k)))\n\n"
                                       "def tn (a,b,n):\n"
                                       "\tif n == 0: return 1\n"
                                       "\tif n == 1: return (a+b)\n"
                                       "\tk = 0\n"
                                       "\tx = 0\n"
                                       "\twhile k <= n:\n"
                                       "\t\tx += ncr(n,k)*(a**(n-k))*(b**k)\n"
                                       "\t\tk += 1\n"
                                       "\treturn x\n\n";

const QString bcFunctionNamePattern = "define\\s+(\\D\\w*)\\s*";
const QString bcFunctionArgumentsPattern = "\\(([\\w\\d,]*)\\)";
const QString bcFunctionBodyPattern = "\\W+\\{\\n([\\w\\W\\d]*)\\}";

const QString pythonFunctionNamePattern = "def\\s(\\D\\w*)\\s";
const QString pythonFunctionArgumentsPattern = "\\(([\\w\\d,]*)\\)";
const QString pythonFunctionBodyPattern = "\\W+\\n([\\w\\W\\d]*)";

const QString gpl = "###########################################################################\n"
"#  Copyright (C) 2005 by Emiliano Gulmini                                 #\n"
"#  emi_barbarossa@yahoo.it                                                #\n"
"#                                                                         #\n"
"#  This program is automatically generated by kalcoolus.                  #\n"
"#  This program falls under the terms of GNU General Public License       #\n"
"#  as published by the Free Software Foundation;                          #\n"
"#  either version 2 of the License, or (at your option) any later version.#\n"
"#                                                                         #\n"
"#  See the GNU General Public License for more details.                   #\n"
"#                                                                         #\n"
"#  A copy of the GNU General Public License is available along with       #\n"
"#  kalcoolus.                                                             #\n"
"#                                                                         #\n"
"#  You should have received a copy of the GNU General Public License      #\n"
"#  along with this program; if not, write to the                          #\n"
"#  Free Software Foundation, Inc.,                                        #\n"
"#  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              #\n"
"###########################################################################\n";
};
#endif
