/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//QT Headers
#include <qdialog.h>
//KDE Headers
#include <kpushbutton.h>
#include <kconfig.h>
#include <ktextedit.h>
//Local Headers
#include "keyboard.h"
#include "service.h"
#include "codegenerator.h"
#include "functionsdb.h"
#include "constantsdb.h"

Keyboard::Keyboard(KConfig* config, KTextEdit* inDisplay, KTextEdit* outDisplay, QMap<QString,  KPushButton*> keyboardMap)
 : QObject()
{
  m_config = config;
  m_inputDisplay = inDisplay;
  m_resultDisplay = outDisplay;
  m_keyboardMap = keyboardMap;
  //This map is used with QObject::sender() to connect several buttons to the same slot
  m_sendersMap["m_b0"] = "0";
  m_sendersMap["m_b1"] = "1";
  m_sendersMap["m_b2"] = "2";
  m_sendersMap["m_b3"] = "3";
  m_sendersMap["m_b4"] = "4";
  m_sendersMap["m_b5"] = "5";
  m_sendersMap["m_b6"] = "6";
  m_sendersMap["m_b7"] = "7";
  m_sendersMap["m_b8"] = "8";
  m_sendersMap["m_b9"] = "9";
  m_sendersMap["m_bA"] = "A";
  m_sendersMap["m_bB"] = "B";
  m_sendersMap["m_bC"] = "C";
  m_sendersMap["m_bD"] = "D";
  m_sendersMap["m_bE"] = "E";
  m_sendersMap["m_bF"] = "F";

  m_sendersMap["m_bImaginary"] = "i";

  m_sendersMap["m_bPlus"] = "+";
  m_sendersMap["m_bMinus"] = "-";
  m_sendersMap["m_bMult"] = "*";
  m_sendersMap["m_bDiv"] = "/";
  m_sendersMap["m_bLess"] = "<";
  m_sendersMap["m_bGreat"] = ">";
  m_sendersMap["m_bLessEqual"] = "<=";
  m_sendersMap["m_bGreatEqual"] = ">=";
  m_sendersMap["m_bIdentical"] = "==";
  m_sendersMap["m_bDifferent"] = "!=";
  m_sendersMap["m_bDot"] = ".";
  m_sendersMap["m_bPercent"] = "%";
  m_sendersMap["m_bLeftRound"] = "(";
  m_sendersMap["m_bRightRound"] = ")";
 // m_sendersMap["m_bLeftSquare"] = "[";
 // m_sendersMap["m_bRightSquare"] = "]";

  m_sendersMap["m_bSin"] = "sin()";
  m_sendersMap["m_bCos"] = "cos()";
  m_sendersMap["m_bTan"] = "tan()";
  m_sendersMap["m_bAtan"] = "atan()";
  m_sendersMap["m_bLog"] = "log()";
  m_sendersMap["m_bLn"] = "ln()";
  m_sendersMap["m_bExp"] = "exp()";
  m_sendersMap["m_bSqr"] = "sqr()";
  m_sendersMap["m_bSqrt"] = "sqrt()";
  m_sendersMap["m_bPower"] = "pow(,)";
  m_sendersMap["m_bFact"] = "fact()";
  m_sendersMap["m_bSimpleDisposition"] = "npr(,)";
  m_sendersMap["m_bRepeatedDisposition"] = "nrr(,)";
  m_sendersMap["m_bBinomial"] = "tn(,,)";
  m_sendersMap["m_bCombination"] = "ncr(,)";
  m_sendersMap["m_bPercentage"] = "percent(,)";
  m_sendersMap["m_bRealPart"] = "re()";
  m_sendersMap["m_bImaginaryPart"] = "im()";
  m_sendersMap["m_bConjugate"] = "conj()";
  m_sendersMap["m_bArgument"] = "arg()";
  m_sendersMap["m_bModulus"] = "mod()";

  connect(m_keyboardMap["1"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["2"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["3"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["4"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["5"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["6"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["7"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["8"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["9"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["0"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["A"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["B"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["C"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["D"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["E"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));
  connect(m_keyboardMap["F"], SIGNAL(clicked()), this, SLOT(slotNumberButton()));

  connect(m_keyboardMap["Im"], SIGNAL(clicked()), this, SLOT(slotImaginaryButton()));
  connect(m_keyboardMap["newline"], SIGNAL(clicked()), this, SLOT(slotNewLineClicked()));

  connect(m_keyboardMap["/"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["."], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["*"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["+"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["-"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));

  connect(m_keyboardMap[">"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["<"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap[">="], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["<="], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["=="], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["!="], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap["("], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));
  connect(m_keyboardMap[")"], SIGNAL(clicked()), this, SLOT(slotOperatorButton()));

  connect(m_keyboardMap["sin"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["cos"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["tan"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["atan"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["log"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["ln"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["exp"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["sqr"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["sqrt"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["pow"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["fact"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["npr"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["nrr"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["binom"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["ncr"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["percent"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["real"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["imag"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["conj"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["arg"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
  connect(m_keyboardMap["mod"], SIGNAL(clicked()), this, SLOT(slotFunctionButton()));
}


Keyboard::~Keyboard()
{
  m_config = 0;
  m_inputDisplay = 0;
  m_resultDisplay = 0;
}

// Private Slots

/*!
    \fn Keyboard::slotNumberButton()
 */
void Keyboard::slotNumberButton()
{
  /* sender()->name() tells us which button was pressed
   * then we map it into a operand symbol */
  QString digit = m_sendersMap[sender()->name()];
  Service::insertStringIntoEditor(m_inputDisplay,digit, 0, 1);
}

/*!
    \fn Keyboard::slotOperatorButton()
 */
void Keyboard::slotOperatorButton()
{
  /* sender()->name() tells us which button was pressed
   * then we map it into a operand symbol */
  QString operation = m_sendersMap[sender()->name()];
  Service::insertStringIntoEditor(m_inputDisplay,operation, 0, operation.length());
}

/*!
    \fn Keyboard::slotNewLineClicked()
 */
void Keyboard::slotNewLineClicked()
{
  // Going to the next line 
  int para,
      index;
  m_inputDisplay->getCursorPosition(&para,&index);
  // Advancing of one paragraph 
  para++;
  // index must be at the beginning of the line 
  index = 0;
  m_inputDisplay->insertAt("\n", para, 0);
  // Reset cursor postion 
  m_inputDisplay->setCursorPosition(para, 0);
}



/*!
    \fn Keyboard::slotFunctionButton()
 */
void Keyboard::slotFunctionButton()
{
  /* sender()->name() tells us which button was pressed
     then we map it into a function symbol */
  QString function = m_sendersMap[sender()->name()];
  Service::insertStringIntoEditor(m_inputDisplay,function, 0, function.length()-1);
//  m_inputBuffer = m_inputDisplay->text();
}


/*!
    \fn Keyboard::slotImaginaryButton()
 */
void Keyboard::slotImaginaryButton()
{
 /* sender()->name() tells us which button was pressed
  * then we map it into a operand symbol */
  QString im = m_sendersMap[sender()->name()];
  Service::insertStringIntoEditor(m_inputDisplay,im, 0, 1);
//  m_inputBuffer = m_inputDisplay->text(); 
}
#include "keyboard.moc"
