/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KEYBOARD_H
#define KEYBOARD_H

#include <qobject.h>
#include <qmap.h>

class KConfig;
class KPushButton;
class KTextEdit;

/**
 * @short Manages keyboard
   @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */
class Keyboard : public QObject
{
  Q_OBJECT
  QMap<QString,  KPushButton*> m_keyboardMap;
  QMap<QString, QString> m_sendersMap;
  KTextEdit* m_inputDisplay,
           * m_resultDisplay;
  KConfig* m_config;

  public:
    Keyboard(KConfig* config, KTextEdit* inDisplay, KTextEdit* outDisplay, QMap<QString,  KPushButton*> keyboardMap);

    ~Keyboard();

  private slots:
    void slotNumberButton();
    void slotOperatorButton();
    void slotNewLineClicked();
    void slotFunctionButton();
    void slotImaginaryButton();
};

#endif
