/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qstringlist.h>

#include "matrix.h"

Matrix::Matrix()
{
}

Matrix::Matrix(const Matrix& m)
{
  rows = m.rows;
  cols = m.cols;
  name = m.name;
  function = m.function;
  matrix = m.matrix;
}

Matrix::~Matrix()
{
}

Matrix& Matrix::operator=(const Matrix& m)
{
  rows = m.rows;
  cols = m.cols;
  name = m.name;
  function = m.function;
  matrix = m.matrix;
  return (*this);
}

void Matrix::init(int r, int c, const QString& n, const QStringList& m)
{
  rows = r;
  cols = c;
  name = n;
  matrix = m;
}

void Matrix::populateMatrix(const QStringList& m)
{
  matrix = m;
}

void Matrix::modifyElement(int r, int c, const QString& e)
{
  int pos = cols * (r - 1) + (c - 1);
  matrix[pos] = e;
}

