/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MATRIX_H
#define MATRIX_H

#include <qstring.h>
#include <qstringlist.h>


/**
 * @short Stores matrix information for the utilities page
   @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
*/

class Matrix
{
  public:
    int rows,
        cols;
    QString name,
            function;
    QStringList matrix;
  public:
    Matrix();
    Matrix(const Matrix&);
    Matrix& operator=(const Matrix&);
    ~Matrix();
    void init(int r, int c, const QString& n, const QStringList& m);
    void populateMatrix(const QStringList& m);
    void modifyElement(int r, int c, const QString& e);
};

#endif
