/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "service.h"

Service::Service(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


Service::~Service()
{
}

/*!
    \fn Service::replaceAllSubstrings(QString& orig, int length,QString olds, QString news)
 */
void Service::replaceAllSubstrings(QString& orig, int length, QString olds, QString news)
{
  int pos = orig.find(olds, 0);
      while(pos not_eq -1)
        {
          orig.replace(pos, length, news);
          pos = orig.find(olds, pos);
        }
}

/*!
    \fn Service::insertStringIntoEditor(KTextEdit* d, const QString& s, int dpara, int dindex)
 */
void Service::insertStringIntoEditor(KTextEdit* d, const QString& s, int dpara, int dindex)
{
  // Getting cursor position 
  int para,
      index;
  d->getCursorPosition(&para, &index);
  // Inserting the digit that maps the button 
  d->insertAt(s, para, index);
  // Updating cursor position 
  d->setCursorPosition(para + dpara, index+dindex);
}


#include "service.moc"
