/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//QT Headers
#include <qstring.h>
#include <qstringlist.h>
#include <qspinbox.h>
#include <qfile.h>
#include <qiconview.h>

//KDE Headers
#include <kpushbutton.h>
#include <ktextedit.h>
#include <klineedit.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

//Local Headers
#include "service.h"
#include "utilities.h"
//#include "angle.h"
#include "octaveworkspace.h"
#include "matrix.h"
#include "kalcoolusmatrixeditor.h"
#include "configuration.h"

Utilities::Utilities(Configuration* configuration, QSpinBox* d, QSpinBox* m, QSpinBox* s, KLineEdit* rad, KPushButton* reset, KPushButton* copyRad, KPushButton* copyDeg, QIconView* iconWS, KPushButton* newMatrix, KTextEdit* display) : QObject()
{
  m_configuration = configuration;
  //Angle Converter
  m_angle = new Angle();
  m_spbxDegrees = d;
  m_spbxMinutes = m;
  m_spbxSeconds = s;
  m_leRadians = rad;
  m_bAngleReset = reset;
  m_bCopyRadians = copyRad;
  m_bCopyDegrees = copyDeg;
  m_inputDisplay = display;
  //Matrix
 /* m_matrix = new Matrix();
  m_matrixEditor = new KalcoolusMatrixEditor(m_matrix);*/
  m_iconWorkspace = iconWS;
  m_bNewMatrix = newMatrix;

  connect(m_spbxDegrees, SIGNAL(valueChanged(int)), this, SLOT(slotDegreesInserted()));
  connect(m_spbxMinutes, SIGNAL(valueChanged(int)), this, SLOT(slotDegreesInserted()));
  connect(m_spbxSeconds, SIGNAL(valueChanged(int)), this, SLOT(slotDegreesInserted()));
  connect(m_leRadians, SIGNAL(textChanged(const QString&)), this, SLOT(slotRadiansInserted(const QString&)));
  connect(m_bAngleReset, SIGNAL(clicked()), this, SLOT(slotAngleReset()));
  connect(m_bCopyRadians, SIGNAL(clicked()), this, SLOT(slotCopyRadiansButton()));
  connect(m_bCopyDegrees, SIGNAL(clicked()), this, SLOT(slotCopyDegreesButton()));

  connect(m_bNewMatrix, SIGNAL(clicked()), this, SLOT(slotNewMatrixButton()));
 // connect(m_matrixEditor->m_bCancelMatrix, SIGNAL(clicked()), this, SLOT(slotCancelMatrixButton()));
}

Utilities::~Utilities()
{
  if(m_angle) delete m_angle;
  if(m_matrix) delete m_matrix;
  if(m_matrixEditor) delete m_matrixEditor;
  m_spbxDegrees = 0;
  m_spbxMinutes = 0;
  m_spbxSeconds = 0;
  m_leRadians = 0;
  m_bAngleReset = 0;
  m_bCopyRadians = 0;
  m_bCopyDegrees = 0;
  m_inputDisplay = 0;
  m_configuration = 0;
  m_bNewMatrix = 0;
}

//Angle Converter Utility
/*!
    \fn Utilities::slotRadiansInserted(const QString& value)
 */
void Utilities::slotRadiansInserted(const QString& value)
{
  int d, m, s;
  calculateDegrees(value, d, m, s);

  m_spbxDegrees->disconnect();
  m_spbxMinutes->disconnect();
  m_spbxSeconds->disconnect();
  m_spbxDegrees->setValue(d);
  m_spbxMinutes->setValue(m);
  m_spbxSeconds->setValue(s);
  connect(m_spbxDegrees, SIGNAL(valueChanged(int)), this, SLOT(slotDegreesInserted()));
  connect(m_spbxMinutes, SIGNAL(valueChanged(int)), this, SLOT(slotDegreesInserted()));
  connect(m_spbxSeconds, SIGNAL(valueChanged(int)), this, SLOT(slotDegreesInserted()));
}

/*!
    \fn Utilities::slotDegreesInserted()
 */
void Utilities::slotDegreesInserted()
{
  QString value;
  calculateRadians(m_spbxDegrees->value(),
                   m_spbxMinutes->value(),
                   m_spbxSeconds->value(), value);
  m_leRadians->disconnect();
  m_leRadians->setText(value);
  connect(m_leRadians, SIGNAL(textChanged(const QString&)), this, SLOT(slotRadiansInserted(const QString&)));
  
}

/*!
    \fn Utilities::slotAngleReset()
 */
void Utilities::slotAngleReset()
{
  m_leRadians->setText("0");
  m_spbxDegrees->setValue(0);
  m_spbxMinutes->setValue(0);
  m_spbxSeconds->setValue(0);
}

/*!
    \fn Utilities::slotCopyRadiansButton()
 */
void Utilities::slotCopyRadiansButton()
{
  QString r = radiansStr();
  Service::insertStringIntoEditor(m_inputDisplay, r, 0, r.length());
}

/*!
    \fn Utilities::slotCopyDegreesButton()
 */
void Utilities::slotCopyDegreesButton()
{
  QString r = degreesStr();
  Service::insertStringIntoEditor(m_inputDisplay, r, 0, r.length());
}

/*!
    \fn Utilities::calculateDegrees(const QString& value, int& d, int& m, int& s)
 */
void Utilities::calculateDegrees(const QString& value, int& d, int& m, int& s)
{
  int scale = m_configuration->scale().toInt();
  if(scale > 15) scale = 15;
  //QString pi="3.141592653589793";
  double pi = Resource::PI.left(scale+2).toDouble();
  QString zeros;
          zeros.fill('0', scale);
  double sixty = QString("60." + zeros).toDouble();
  double semicirc = QString("180." + zeros).toDouble();
  //value is in radians
  QString tmp = value;
  //formats value
  if(tmp.contains(".") == 0) tmp += ".000000";
  //calculates degree from value
  double g = tmp.toDouble() * (semicirc / pi);
  
  m_angle->m_deg = g;

  m_angle->m_radStr = tmp;
  //now value is in degrees
  tmp = tmp.setNum(g, 'g', scale);

  m_angle->m_degStr = tmp;

  //calculate degree()
  QString l = tmp.section('.',0,0),
          r = "0." + tmp.section('.',1,1);

  d = l.toInt();
  //calculates minutes(')
  tmp = r.setNum(r.toDouble() * sixty, 'g', scale);
  l = tmp.section('.',0,0);
  r = "0." + tmp.section('.',1,1);

  m = l.toInt();
  //calculates seconds('')
  tmp = r.setNum(r.toDouble() * sixty, 'g', scale);
  l = tmp.section('.',0,0);
  r = "0." + tmp.section('.',1,1);

  s = l.toInt();
}

/*!
    \fn Utilities::calculateRadians(int d, int m, int s, QString& value)
 */
void Utilities::calculateRadians(int d, int m, int s, QString& value)
{
  int scale = m_configuration->scale().toInt();
  if(scale > 15) scale = 15;
  //QString pi="3.141592653589793";
  double pi = Resource::PI.left(scale+2).toDouble();
  QString zeros;
          zeros.fill('0', scale);
  double sixty = QString("60." + zeros).toDouble();
  double semicirc = QString("180." + zeros).toDouble();
  double g = (((double(s) / sixty) + double(m)) / sixty) + double(d);

  m_angle->m_degStr.setNum(g, 'g', scale);

  double r = g * (pi / semicirc);

  value.setNum(r,'g',scale);

  m_angle->m_rad = r;
  m_angle->m_radStr = value;
}


//Matrix Utility
void Utilities::slotNewMatrixButton()
{
 // matrixShow();
  m_matrix = new Matrix();
  m_matrixEditor = new KalcoolusMatrixEditor(m_matrix);
  if(m_matrixEditor->exec() == QDialog::Accepted)
    {
      m_matrixWorkspace->insertElement(*m_matrix);
      (void) new QIconViewItem(m_iconWorkspace, m_matrix->name);
      //emit addToWorkspace(*m_matrix);
    }
}

void Utilities::slotCancelMatrixButton()
{
  
}

void Utilities::applyFunctionToMatrix(QStringList m)
{
 Q_UNUSED(m);
}

void Utilities::matrixShow()
{
  /*if(m_matrixEditor->exec() == QDialog::Accepted)
    {
      m_matrixWorkspace->insertElement(*m_matrix);
      //emit addToWorkspace(*m_matrix);
    }*/
 /* m_matrixEditor->setModal(true);
  m_matrixEditor->show();*/
}

void Utilities::slotGetScriptError(KProcess* proc, char* s, int i)
{
  Q_UNUSED(proc);
  //KMessageBox::information(0, i18n(QCString(s,i+1)), "Copyright notice");
}

void Utilities::slotGetScriptOutput(KProcess* proc, char* s, int i)
{
  Q_UNUSED(proc);
  //KMessageBox::information(0, i18n(QCString(s,i+1)), "Copyright notice");
  m_calculatedAngle = QCString(s,i+1);
}

void Utilities::slotProcessExited(KProcess* proc)
{
  Q_UNUSED(proc);
}


#include "utilities.moc"
