/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini   *
 *   emi_barbarossa@yahoo.it   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef UTILITIES_H
#define UTILITIES_H

//QT Headers
#include <qobject.h>
#include <qvaluelist.h> 
class QString;
class QStringList;
class QSpinBox;
class QPopupMenu;
class QIconView;

//KDE Headers
class KTextEdit;
class KPushButton;
class KLineEdit;
class KProcess;

//Local Headers
#include "angle.h"
class Matrix;
class KalcoolusMatrixEditor;
class OctaveWorkspace;
class Configuration;

/**
 * @short Implements the capabilities of the utilities tab page

   @author Emiliano Gulmini <emi_barbarossa@yahoo.it>
 */

class Utilities : public QObject
{
  Q_OBJECT
  private:
    QString m_calculatedAngle;
    Configuration* m_configuration;
    KTextEdit* m_inputDisplay;
    //Angle utility
    Angle* m_angle;
    QSpinBox* m_spbxDegrees,
            * m_spbxMinutes,
            * m_spbxSeconds;
    QLineEdit* m_leRadians;
    KPushButton* m_bAngleReset,
               * m_bCopyRadians,
               * m_bCopyDegrees;
    //Matrix utility
    Matrix* m_matrix;
    KPushButton* m_bNewMatrix/*,
               * m_cancelMatrix*/;
    KalcoolusMatrixEditor* m_matrixEditor;
    OctaveWorkspace* m_matrixWorkspace;
    QIconView* m_iconWorkspace;
  public:
    Utilities(Configuration* configuration,
              //Angle Converter
              QSpinBox* d,
              QSpinBox* m,
              QSpinBox* s,
              KLineEdit* rad,
              KPushButton* reset,
              KPushButton* copyRad,
              KPushButton* copyDeg,
              //Matrix
              QIconView* iconWS,
              KPushButton* newMatrix,
              KTextEdit* display);

    ~Utilities();
    //Angle converter utility
  private:
    void calculateDegrees(const QString& value, int& d, int& m, int& s);
    void calculateRadians(int d, int m, int s, QString& value);
  public:
    double degrees() const { return m_angle->m_deg; }
    double radians() const { return m_angle->m_rad; }
    QString degreesStr() const { return m_angle->m_degStr; }
    QString radiansStr() const { return m_angle->m_radStr; }
  private slots:
    void slotRadiansInserted(const QString& value);
    void slotDegreesInserted();
    void slotAngleReset();
    void slotCopyRadiansButton();
    void slotCopyDegreesButton();

    //Matrix utility
  public:
    Matrix* matrix() const { return m_matrix; }
    void selectFunction(QString f);
    void applyFunctionToMatrix(QStringList m);
    void matrixShow();
  private slots:
     //  void slotApplyFunctionToMatrix();
    void slotNewMatrixButton();
    void slotCancelMatrixButton();
   // void slotAddToWorkspace(const Matrix&);
   // void slotPopupMenu(QIconViewItem*, const QPoint&);
  signals:
    void addToWorkspace(const Matrix& m);
    void delFromWorkspace(const Matrix& m);

  //Others
  private slots:
    void slotGetScriptError(KProcess* proc, char* s, int i);
    void slotGetScriptOutput(KProcess* proc, char* s, int i);
    void slotProcessExited(KProcess* proc);
};

#endif
