/***************************************************************************
 *   Copyright (C) 2005 by Michael Goettsche                               *
 *   michael.goettsche@kdemail.net                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef EXERCISEDIALOG_H_
#define EXERCISEDIALOG_H_


#include "exercisedialog_base.h"

class QStringList;

struct KalculLevel
{
    
    QString name;
    QString type;
    QString numOfQuestions;
    QString difficulty;
    QString questions;
};

class ExerciseDialog : public ExerciseDialog_base
{
Q_OBJECT

public:
    ExerciseDialog(QWidget *parent=0);
    
signals:
    void signalPracticeAddition();
    void signalPracticeSubtraction();
    void signalPracticeMultiplication();
    void signalPracticeDivision();

    void setLevel(const QString& level);
    
protected slots:
    void raisePracticeWidget();
    void raiseLevelWidget();

    void accept();
    void reject();

    void levelClicked(QListBoxItem* item);

    void goClicked();

private:
    QMap<QString, KalculLevel> levelInfoMap;
    KalculLevel currentLevel;
};


#endif //EXERCISEDIALOG_H_
