/***************************************************************************
 *   Copyright (C) 2005 by Michael Goettsche                               *
 *   michael.goettsche@kdemail.net                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include <qlabel.h>
#include <qslider.h>
#include <qcheckbox.h>

#include "timer.h"
#include "settings.h"


Timer::Timer()
    :Timer_base()
{
    timeLabel->setText(QString::number(Settings::time()) + " " + i18n("minutes"));

    if (Settings::timerBool())
        kcfg_Time->setEnabled(true);
    else
        kcfg_Time->setEnabled(false);

    connect(kcfg_TimerBool, SIGNAL(toggled(bool)), kcfg_Time, SLOT(setEnabled(bool)));
    connect(kcfg_Time, SIGNAL(valueChanged(int)), this, SLOT(sliderValueChanged()));
}


void Timer::sliderValueChanged()
{
    timeLabel->setText(QString::number(kcfg_Time->value()) + " " + i18n("minutes"));
}


#include "timer.moc"
