/***************************************************************************
                          kbibeditentrydlg.h  -  description
                             -------------------
    begin                : Sat May 31 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIBEDITENTRYDLG_H
#define KBIBEDITENTRYDLG_H

#include <qwidget.h>
#include <ktextedit.h>
#include <kdialogbase.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <klineedit.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qvaluelist.h>
#include <qlistview.h>

#include <kpushbutton.h>

#include "bibentrytable.h"
#include "bibentry.h"
#include "fieldwidget.h"
//#include "entrydef.h"

/**
  *@author Thach Nguyen
  */

class KBibEditEntryDlg : public KDialogBase
{
    Q_OBJECT
public:
    KBibEditEntryDlg(BibEntry *entry = 0, QWidget *parent=0, const char *name=0);
    ~KBibEditEntryDlg();
    /** No descriptions */
    void updateDlg(QString entryTypeName);
    /** No descriptions */
    void updateContent(BibEntry *entry);
    /** No descriptions */
    BibEntry * getBibEntry(void);
    BibEntry * getEditedBibEntry(void );
    void accept(void);


private:
    int fieldIdx;

    QPtrList<GUI::FieldWidget> rqFields;
    QPtrList<GUI::FieldWidget> optFields;

    QComboBox * entryTypeSelect;
    KLineEdit * keyField;

    QTabWidget *reqTab;
    QTabWidget *optTab;

    QScrollView *rqScrollView;
    QGroupBox * rqBox;
    QScrollView *optScrollView;
    QGroupBox * optBox;
    QLabel* keyLabel;
    QLabel* entryTypeLabel;

    BibEntry *m_entry;

    QPushButton * createKeyBttn;
    QPushButton * lockKeyBttn;
    QPushButton * editTypeBttn;
    KTextEdit *sourceEdit;
	KTextEdit *noteEdit;
	QLabel *noteLabel;
    KTextEdit *abstractEdit;
	QLabel *abstractLabel;
    QWidget *abstractPage;
    QTabWidget *mainTab;
    int prevTabIndex;

    QVBoxLayout *rqLayout;
    QVBoxLayout *optLayout;
	
	
	KListView *extraFieldView;
	KPushButton *extraFieldAddBtn;
	KPushButton *extraFieldEditBtn;
	KPushButton *extraFieldDeleteBtn;
	
	bool m_modified;
	
private slots:
	void slotExtraFieldAdd();
	void slotExtraFieldEdit();
	void slotExtraFieldDelete();
	void slotExtraFielItemRenamed( QListViewItem * item, int col, const QString & text );
	void updateExtraFieldGUI();	
	void slotSetModified(bool modified = true);
	
public slots: // Public slots
    /** No descriptions */
    void slotEntryTypeChange(int);
    /** No descriptions */
    /** No descriptions */
    void slotCreateKey();


    void slotLockKey();
    void slotTabChanged();
	
	virtual void slotCancel();
};

#endif
