/***************************************************************************
                          kbibpreview.cpp  -  description
                             -------------------
    begin                : Fri Jan 30 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbibpreview.h"
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <krun.h>

#include <qsplitter.h>
#include <string.h>
#include <qclipboard.h>
#include <qcursor.h>
#include <qpoint.h>
#include "kbib.h"
#include "kbibdoc.h"

#define copySelectID 9

KBibPreview::KBibPreview(QWidget *parent) : QTextBrowser(parent)
{
    bibItem = 0;
	popupMenu = new KPopupMenu(this);
	
	popupMenu -> insertItem(i18n("Copy all text"), this, SLOT(slotCopyAll()), 0, 8);
	popupMenu -> insertItem(i18n("Copy selected text"), this, SLOT(slotCopySelected()), 0, copySelectID);

	
	connect(this, SIGNAL(linkClicked(const QString &)  ),this,
            SLOT(slotLinkClicked(const QString &)));

	connect(this, SIGNAL(copyAvailable(bool)  ),this,
			SLOT(slotCopyAvailableChange(bool)));
	
	popupMenu -> setItemEnabled (copySelectID, false);	
	
}
KBibPreview::~KBibPreview()
{}
/** No descriptions */
void KBibPreview::setBibEntry(BibEntry * item)
{
    bibItem = item;
}
/** No descriptions */
void KBibPreview::updatePreview()
{
    if (!bibItem)
    {
        clear();
        return;
    }
    QSplitter* vbox = (QSplitter*) parent();
    QSplitter* mbox = (QSplitter*) vbox->parent();
    KBibApp* win = (KBibApp*) mbox->parent();
	KBibDoc *doc = win->getDocument();	
	
    int previewMode = win->getPreviewMode();

    QString st;

    switch(previewMode)
    {
    case 0:
		st = doc->getEntryList()->detailedEntry(bibItem);
        break;

    case 1:
		st = doc->getEntryList()->formatEntry(bibItem);
        break;


    default:
        break;
    }
    setText(st);


}
/** No descriptions */
void KBibPreview::slotLinkClicked(const QString & link)
{
    updatePreview();
    QSplitter* vbox = (QSplitter*) parent();
    QSplitter* mbox = (QSplitter*) vbox->parent();
    KBibApp* win = (KBibApp*) mbox->parent();
	KProcess* proc = new KProcess;
	proc->clearArguments();
	(*proc) << (win->kbibConfigState).browser;
	(*proc) << (KURL(link)).prettyURL();

    if(!proc->start())
    {
        KMessageBox::error(this, i18n("Could not open URL.") );
    }
}

void KBibPreview::contentsContextMenuEvent( QContextMenuEvent * )
{
	popupMenu->exec( QCursor::pos() );
}

void KBibPreview::slotCopyAll(){
	QClipboard *cb = QApplication::clipboard();
	this->selectAll(true);
	cb->setText(this->selectedText());	
	this->selectAll(false);
}

void KBibPreview::slotCopySelected(){
	QClipboard *cb = QApplication::clipboard();
	cb->setText(this->selectedText());	
}


void KBibPreview::slotCopyAvailableChange(bool yes){
	if (yes)
		popupMenu -> setItemEnabled (copySelectID, true);	
	else
		popupMenu -> setItemEnabled (copySelectID, false);		
}
