//
// C++ Interface: scitationsearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SCITATIONSEARCHER_H
#define SCITATIONSEARCHER_H

#include "searcher.h"
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/

class KComboBox;

class ScitationSearcher;

class ScitationConfigWidget : public SearcherConfigWidget {
	public:
		ScitationConfigWidget(QWidget* parent, ScitationSearcher* searcher = 0);
		virtual void updateSearcher();
	private:
		KComboBox* m_dbCombo;
};

class ScitationSearcher : public searcher
{
Q_OBJECT
	public:
		ScitationSearcher(QObject* parent, const char* name=0);
		
		virtual ~ScitationSearcher();

		virtual QString source() const;
		virtual void setSource(const QString );
		virtual QString helpURL() {return QString::fromLatin1("http://scitation.aip.org/jhtml/verhelp.jsp")  ; }
		virtual bool isSearching() const { return m_started; }
		virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
		virtual void search(QString queryString);
		virtual void stop();
		virtual Type type() const { return Scitation; }
		virtual void readConfig(KConfig* config, const QString& group);
		virtual void saveConfig(KConfig* config);
		virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
		friend class ScitationConfigWidget;
		virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
		virtual void retrieveRange(unsigned int min, unsigned int max);
		virtual QStringList searchKey();
		virtual int maxSearchTerms() {return 100; }
		static QString defaultName();

	private slots:
		void slotData(KIO::Job* job, const QByteArray& data);
		void slotComplete(KIO::Job* job);

	private:
		void searchResults();
		void fetchResults();
		void fetchBibtex();
		QString searchField(QString value, SearchKey key);
		QString searchBool(int op);

		enum Step {
			Begin,
			Search,
			Wait,
			Fetch,
			FetchBibtex
		};

		KURL m_url;
		QByteArray m_data;
		QString m_query;
		int m_start, m_end;
		QString m_db;
		QString m_queryKey;
		QGuardedPtr<KIO::Job> m_job;
		Step m_step;
		bool m_started;

		int current_page;
		int last_retrieved;
		int retrieved;
};

#endif
