/***************************************************************************
                          finestraprincipale.cpp  -  description
                             -------------------
    begin                : Sun Jun 11 2000
    copyright            : (C) 2000 by Catuzzi Samuele
    email                : samuele_catuzzi@yahoo.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "finestraprincipale.h"
#include <kmessagebox.h>
#include <qregexp.h>
#include <qpicture.h>
#include <qpainter.h>
#include <qpixmap.h>
#include "codimg.h"


//FinestraPrincipale::FinestraPrincipale()
FinestraPrincipale::FinestraPrincipale(QWidget *parent, const char *name) : FinestraPrincipale2(parent,name)
{
// initDialog();

 MeseComboBox->setCurrentItem(0);

 connect(AnnullaButton,SIGNAL(clicked()),SLOT(Pulisci()) );
 connect(EseguiButton,SIGNAL(clicked()),SLOT(mostracodice()) );
 
 connect(tessera_button,SIGNAL(clicked()),SLOT(mostra_tessera()) );

 setfocus_cognome();

 connect(CognomeLineEdit,SIGNAL(returnPressed()),SLOT(setfocus_nome()) );
 connect(NomeLineEdit,SIGNAL(returnPressed()),SLOT(setfocus_comune()) );
 connect(ComuneLineEdit,SIGNAL(returnPressed()),SLOT(setfocus_cognome()) );

}

FinestraPrincipale::~FinestraPrincipale(){
}
/**  */
void FinestraPrincipale::Pulisci(){
 CognomeLineEdit->clear();
 NomeLineEdit->clear();
 CodiceLineEdit->clear();
 ComuneLineEdit->clear();
}
/**  */

/**  */
void FinestraPrincipale::mostracodice(){
 int numero=0;
 char numeri[]="0123456789";

  //giorno
 numero=atoi(GiorniSpinBox->text());
 datadinascita[0]=numeri[(numero/10)];
 datadinascita[1]=numeri[(numero%10)];
  //mese
 numero=(MeseComboBox->currentItem());
 numero++ ;
 datadinascita[2]=numeri[(numero/10)];
 datadinascita[3]=numeri[(numero%10)];
  //anno
 strncpy((datadinascita+4),(AnnoSpinBox->text()),4);
 datadinascita[8]='\0';

 if ( (QString)(SessoComboBox->currentText()) == (QString)"Maschio") sesso='M' ;
 else sesso='F' ;
 
 cognome=CognomeLineEdit->text();
 nome=NomeLineEdit->text();
 citta=ComuneLineEdit->text();
 
 CodiceLineEdit->setText(calcolacodice());

}


char * FinestraPrincipale::levaconsonanti(const char * stringa)
{
 QString appoggio;
 char * temp=new char[strlen(stringa)+1];
 appoggio=stringa ;
 appoggio=appoggio.stripWhiteSpace();
 appoggio.replace( QRegExp("[BCDFGHJKLMNPQRSTVWXYZ]"),"");
 cstrcpy(temp,(const char *)(appoggio));
 return temp;
}


char * FinestraPrincipale::levavocali(const char *stringa)
{
 QString appoggio;
 char * temp=new char[strlen(stringa)+1];
 appoggio=stringa;
 appoggio=appoggio.stripWhiteSpace();
 appoggio.replace( QRegExp("[AEIOU]"),"");
 cstrcpy(temp,(const char *)(appoggio));
 return temp;
}


int FinestraPrincipale::importadati()
{
 comune *elemento=0;
 FILE * importa;

 if ((importa=fopen((const char *)posizione_comuni,"r"))!=NULL) cout<<"File Aperto"<<endl ;
 else {
       QString messaggio;
       messaggio="File comuni.bin non trovato in posizione:\n  "+posizione_comuni;
       cout<<((const char *)messaggio)<<endl;
       messaggio=messaggio+"\ncopiarlo in questa posizione oppure reinstallare l'applicazione";
       messaggio=messaggio+"\nimpostando --prefix alla corretta posizione della directory di KDE";
       KMessageBox::information(this,((const char *)messaggio),"   Errore !!",0,false );
       exit(0);
      }

 cout<<"inizio cattura dati..\n"<<endl;
 fseek(importa, 0, SEEK_SET);
 char ch='\0';
 int i;
 int count=0;

 while(ch!=EOF) {

    elemento= new comune ;

    for(i=0;i<20;i++) elemento->nomecitta[i]=fgetc(importa);  //leggi nomecitt�    
    elemento->nomecitta[20]='\0' ;


    ch=fgetc(importa);

    elemento->sigla[0]=fgetc(importa);
    elemento->sigla[1]=fgetc(importa);
    elemento->sigla[2]='\0' ;

    ch=fgetc(importa);

    for(i=0;i<5;i++)  elemento->codice[i]=fgetc(importa);     //leggi codice
    elemento->codice[4]='\0' ;

    lista.append(elemento);

    count++ ;
   } ;

 cout<<"\nImportate "<<count<<" strutture dati comune"<<endl;
 fclose(importa);
 return 1 ;
}


  // ritorna il codicefiscale in caso di successo, 0 se c'e' un errore
char * FinestraPrincipale::calcolacodice()
{
 char *codicefiscale=new char[17];
 char cgnm[31];
 char ooe[31]; // contiene solo vocali
 char nm[31];
 char oe[31];

 comune *elemento=0;
 QString appoggio;
 QString appoggio_sigla;

 char cod_comune[10]="";
 char temp[3];
 int numvocali=0;
 int numconsonanti=0;
 int numero,i,j;
 char numeri[]="0123456789";
 char alfabeto[]    =    "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
 char alfabeto_dispari[]="BAKPLCQDREVOSFTGUHMINJWZYX";

 // ora filtro via gli spazi e i caratteri non alfabetici

 // cognome
 cognome=cognome.upper();
 cognome=cognome.replace( QRegExp("[^A-Z]"),"");
 cognome=cognome.stripWhiteSpace();

 // nome
 nome=nome.upper() ;
 nome=nome.stripWhiteSpace() ;
 nome=nome.replace( QRegExp("[^A-Z]"),"");

 // comune
 citta=citta.upper() ;
 citta=citta.replace( QRegExp("[^A-Z]"),"");
 citta=citta.stripWhiteSpace();

 // controllo dati inseriti & eventuali errori

 if ((cognome.length())==0)
      {
       KMessageBox::information(this,"Errore sul cognome, dato non valido","   Errore !!",0,false );
       return NULL;
      }

 if ((nome.length())==0)
      {
       KMessageBox::information(this,"Errore sul nome, dato non valido","   Errore !!",0,false );
       return NULL;
      }

 if ((citta.length())==0)
      {
       KMessageBox::information(this,"Errore sul comune, dato non valido\ninserire anche solo parzialmente il nome\ndel comune di nascita o stato estero","   Errore !!",0,false );
       return NULL;
      }


 if ( ((strlen(datadinascita))!=8) || ((atol(datadinascita))<=0) || ((atol(datadinascita))>31129999) )
      {
       KMessageBox::information(this,"Errore in data di nascita","   Errore !!",0,false );
       cout<<"\nErrore in data di nascita, nella forma ggmmaaaa"<<endl;
       return NULL;
      }

 if (sesso=='m') sesso='M';
 if (sesso=='f') sesso='F';

 if ((sesso != 'M') && (sesso != 'F'))  KMessageBox::information(this,"Errore di cattura del valore sesso","   Errore !!",0,false );


 if (lista.at(0) == NULL)
    {
    KMessageBox::information(this,"Errore non e' stata catturata la lista dei comuni","   Errore !!",0,false );
    return NULL;
    }
 else
    {
     i=0;
     comune * comune_scelto=NULL;
     while((elemento=lista.at(i))!=NULL)
     {
      appoggio=elemento->nomecitta;
      appoggio_sigla=elemento->sigla;
      appoggio=appoggio.upper();
      appoggio_sigla=appoggio_sigla.upper();

      appoggio=appoggio.replace( QRegExp("[^A-Z]"),"");
      appoggio=appoggio.stripWhiteSpace();

      if ((appoggio.contains(citta,false))>0)
         {
          comune_scelto=new comune;
          cstrcpy(comune_scelto->nomecitta,elemento->nomecitta);
          cstrcpy(comune_scelto->sigla,elemento->sigla);
          cstrcpy(comune_scelto->codice,elemento->codice);
          lista_com_scelti.append(comune_scelto);
         };

      i++ ;
     }    // fine while

     if (lista_com_scelti.count()==0)
        {
         KMessageBox::information(this,"Errore non e' stato possibile trovare il nome \n parziale o completo del comune richiesto","   Errore !!",0,false );
         return NULL;
        };

     if (lista_com_scelti.count()==1)
        {
         elemento=lista_com_scelti.first();
         cout<<"Comune trovato: "<<(elemento->nomecitta)<<" sigla: "<<(elemento->sigla)<<" Codice: "<<(elemento->codice)<<endl;
         cstrcpy( cod_comune,elemento->codice);
          
          //memorizzo i dati del comune
          cstrcpy( comune_attuale.codice,elemento->codice);
          cstrcpy( comune_attuale.sigla,elemento->sigla);
          cstrcpy( comune_attuale.nomecitta,elemento->nomecitta);
          
         ComuneLineEdit->setText(lista_com_scelti.first()->nomecitta);
         lista_com_scelti.clear();
        };

     if (lista_com_scelti.count()>1)
        {
         int indice=0;
         finestradiscelta=new SceltaComune(this,"SceltaComune");
         QString appoggio2;
         finestradiscelta->elemento=citta;
         for(unsigned int i=0;i<(lista_com_scelti.count());i++)
           {
            appoggio2=(QString)(lista_com_scelti.at(i)->nomecitta) + "(" +(QString)(lista_com_scelti.at(i)->sigla)+")" ;
            finestradiscelta->inserisci(appoggio2,(lista_com_scelti.at(i)->nomecitta));
           };
         finestradiscelta->set_view_elem();
         if (finestradiscelta->exec())
            {
              indice=finestradiscelta->indice_attuale();
              if (indice == -1)
                 {
                  lista_com_scelti.clear();
                  delete finestradiscelta;
                  return NULL;
                 };
            }
         else  {
                lista_com_scelti.clear();
                delete finestradiscelta;
                return NULL;
               }
         ComuneLineEdit->setText(lista_com_scelti.at(indice)->nomecitta);
         elemento=lista_com_scelti.at(indice);
         cout<<"Comune trovato: "<<(elemento->nomecitta)<<" sigla: "<<(elemento->sigla)<<" Codice: "<<(elemento->codice)<<endl;
         cstrcpy( cod_comune,elemento->codice);
          
          //memorizzo i dati del comune
          cstrcpy( comune_attuale.codice,elemento->codice);
          cstrcpy( comune_attuale.sigla,elemento->sigla);
          cstrcpy( comune_attuale.nomecitta,elemento->nomecitta);
           
         lista_com_scelti.clear();
         delete finestradiscelta;
        };
   };

//  **************************
//
//       inizio routines
//
//  **************************

//  Ora calcolo il cognome

 strcpy(ooe,levaconsonanti(cognome));
 strcpy(cgnm,levavocali(cognome));

 numvocali=strlen(ooe);
 numconsonanti=strlen(cgnm);

 if ( (cognome.length()) == 0 )
    {
     KMessageBox::information(this,"Errore sul campo cognome, dato non valido","   Errore !!",0,false );
     return NULL;
    };

 switch(numconsonanti)
 {
   case 0 :         // zero consonanti
        if (numvocali==2)
           {
            codicefiscale[0]=ooe[0];
            codicefiscale[1]=ooe[1];
            codicefiscale[2]='X';
           }
        else {   //  caso in cui le vocali o sono 0 o >=3
               KMessageBox::information(this,"Errore sul cognome, caso non previsto da questo algoritmo \n..impossibile calcolare il codice fiscale","   Errore !!",0,false );
               return NULL;
             };
        break;

   case 1 :         // una consonante
        switch(numvocali)
        {
          case 0 :
               KMessageBox::information(this,"Errore sul cognome, caso non previsto da questo algoritmo \n..impossibile calcolare il codice fiscale","   Errore !!",0,false );
               return NULL;

          case 1 :
               codicefiscale[0]=cgnm[0];
               codicefiscale[1]=ooe[0];
               codicefiscale[2]='X';
               break;

          default :
               codicefiscale[0]=cgnm[0];
               codicefiscale[1]=ooe[0];
               codicefiscale[2]=ooe[1];
               break;
        };
        break;

   case 2 :         // due consonanti
        if (numvocali>=1)
           {
            codicefiscale[0]=cgnm[0];
            codicefiscale[1]=cgnm[1];
            codicefiscale[2]=ooe[0];
           }
        else {
               KMessageBox::information(this,"Errore sul cognome, caso non previsto da questo algoritmo \n..impossibile calcolare il codice fiscale","   Errore !!",0,false );
               return NULL;
             };
        break;

   default :
        strncpy(codicefiscale,cgnm,3);
        break;
 }

//  Ora calcolo il nome

 strcpy(oe,levaconsonanti(nome));
 strcpy(nm,levavocali(nome));

 numvocali=strlen(oe);
 numconsonanti=strlen(nm);


 if ((nome.length())==0)
    {
     KMessageBox::information(this,"Errore campo nome, dato non valido","   Errore !!",0,false );
     return NULL;
    };

 switch(numconsonanti)
 {
   case 0 :
        if (numvocali==2)
           {
            codicefiscale[3]=oe[0];
            codicefiscale[4]=oe[1];
            codicefiscale[5]='X';
           }
        else {
               KMessageBox::information(this,"Errore sul nome, caso non previsto da questo algoritmo \n..impossibile calcolare il codice fiscale","   Errore !!",0,false );
               return NULL;
             };
        break;

   case 1 :
        switch(numvocali)
        {
          case 0 :
               KMessageBox::information(this,"Errore sul nome, caso non previsto da questo algoritmo \n..impossibile calcolare il codice fiscale","   Errore !!",0,false );
               return NULL;

          case 1 :
               codicefiscale[3]=nm[0];
               codicefiscale[4]=oe[0];
               codicefiscale[5]='X';
               break;

          default:
               codicefiscale[3]=nm[0];
               codicefiscale[4]=oe[0];
               codicefiscale[5]=oe[1];
               break;
        }
        break;

   case 2 :
        if (numvocali>=1)
           {
            codicefiscale[3]=nm[0];
            codicefiscale[4]=nm[1];
            codicefiscale[5]=oe[0];
           }
        else {
               KMessageBox::information(this,"Errore sul nome, caso non previsto da questo algoritmo \n..impossibile calcolare il codice fiscale","   Errore !!",0,false );
              return NULL;
             };
        break;

   case 3 :
        codicefiscale[3]=nm[0];
        codicefiscale[4]=nm[1];
        codicefiscale[5]=nm[2];
        break;

   default:
        codicefiscale[3]=nm[0];
        codicefiscale[4]=nm[2];
        codicefiscale[5]=nm[3];
        break;
 }

//   Ora calcolo la data

 codicefiscale[6]=datadinascita[6];
 codicefiscale[7]=datadinascita[7];

//   Ora calcolo il carattere del mese

 temp[0]=datadinascita[2];
 temp[1]=datadinascita[3];
 temp[2]='\0' ;

 switch (atoi(temp))   // attenzione le lettere non sono in successione alfabetica
 {
   case 1 : codicefiscale[8]='A' ; break;
   case 2 : codicefiscale[8]='B' ; break;
   case 3 : codicefiscale[8]='C' ; break;
   case 4 : codicefiscale[8]='D' ; break;
   case 5 : codicefiscale[8]='E' ; break;
   case 6 : codicefiscale[8]='H' ; break;
   case 7 : codicefiscale[8]='L' ; break;
   case 8 : codicefiscale[8]='M' ; break;
   case 9 : codicefiscale[8]='P' ; break;
   case 10 : codicefiscale[8]='R' ; break;
   case 11 : codicefiscale[8]='S' ; break;
   case 12 : codicefiscale[8]='T' ; break;
   default:
      KMessageBox::information(this,"Errore sul mese, dato non valido","   Errore !!",0,false );
      return NULL;
 }

 //   Ora calcolo giorno di nascita

 temp[0]=datadinascita[0];
 temp[1]=datadinascita[1];
 temp[2]='\0' ;
 numero=atoi(temp);

 if ( (numero>0)&&(numero<=31) ) // pre scremata
    {
     // effettuo un controllo su quei mesi con meno giorni
     if (((codicefiscale[8]=='S')||(codicefiscale[8]=='D')||(codicefiscale[8]=='H')||(codicefiscale[8]=='P'))&&(numero>30))
        {
          KMessageBox::information(this,"Errore sul giorno, dato non valido","   Errore !!",0,false );
          return NULL;
        };
     if ((codicefiscale[8]=='B')&&(numero>29))  // febbraio ,anno bisestile o no
        {
          KMessageBox::information(this,"Errore sul giorno, dato non valido","   Errore !!",0,false );
          return NULL;
        };

           if (sesso=='M')
               {
                codicefiscale[9]=datadinascita[0];
                codicefiscale[10]=datadinascita[1];
               }
     else {
           numero=numero+40;
                  codicefiscale[9]=numeri[(numero/10)];
                  codicefiscale[10]=numeri[(numero%10)];
          };

    }
 else {
       KMessageBox::information(this,"Errore sul giorno, dato non valido","   Errore !!",0,false );
       return NULL;
      }


 //   Ora inserisco codice comune, non effettuo controlli

 strncpy( codicefiscale+11 ,cod_comune,4);

 //   Ora calcolo l'ultimo carattere, quello di controllo

 numero=0;

 for (i=0;i<=14;i=i+2)  // ciclo per i caratteri dispari
     {
      if (strchr(numeri,codicefiscale[i])==NULL)
         {
          for (j=0;j<=26;j++)
              {
               if (codicefiscale[i]==alfabeto_dispari[j])
                  {
                   numero=numero + j;
                   break;
                  };
              };
         }
      else  switch(codicefiscale[i])         // e' un numero
            {
              case '0' : numero=numero+1;  break;
              case '1' : break;
              case '2' : numero=numero+5;  break;
              case '3' : numero=numero+7;  break;
              case '4' : numero=numero+9;  break;
              case '5' : numero=numero+13; break;
              case '6' : numero=numero+15; break;
              case '7' : numero=numero+17; break;
              case '8' : numero=numero+19; break;
              case '9' : numero=numero+21; break;
            };

     }

 for (i=1;i<=13;i=i+2)  // ciclo per i caratteri pari
     {
      if (strchr(numeri,codicefiscale[i])==NULL)
         {
          for (j=0;j<=26;j++)
              {
               if (codicefiscale[i]==alfabeto[j])
                  {
                   numero=numero + j;
                   break;
                  };
              };
         }
      else  {
             temp[0]=codicefiscale[i];
             temp[1]='\0';
             numero=numero + atoi(temp);    // e' un numero
            }
     }

 numero=numero%26; // il resto della divisione
 codicefiscale[15]=alfabeto[numero];
 codicefiscale[16]='\0';

 cout<<"Codicefiscale:"<<codicefiscale<<endl;
 return codicefiscale ;
}

/**  */
void FinestraPrincipale::SetupChiudiApplicazione(){
 connect(ExitButton,SIGNAL(clicked()),kapp,SLOT(closeAllWindows()) );
}

/**  */
void FinestraPrincipale::setfocus_cognome(){
 CognomeLineEdit->setFocus();
}
/**  */
void FinestraPrincipale::setfocus_nome(){
 NomeLineEdit->setFocus();
}
/**  */
void FinestraPrincipale::setfocus_comune(){
 ComuneLineEdit->setFocus();
}


/*!
    \fn FinestraPrincipale::mostra_tessera()
 */
void FinestraPrincipale::mostra_tessera()
{
     
 if ( ! CodiceLineEdit->text().isEmpty () ) {
         
         QPainter paint;
         QString datadinascita_slashes;

         QPixmap tessera = QPixmap((const char**)codimg);
         
         paint.begin( &tessera );
         //paint.drawPixmap( 0, 0, pixmap );

        //**************************************************
         QFont f( "times", 19, QFont::Bold );
         paint.setFont( f );
         paint.setPen( Qt::black );

          
         paint.drawText( 75, 110, CodiceLineEdit->text() );
         
         f.setPointSize(15);
         f.setBold(false);
         paint.setFont( f );
         
          QChar sex(sesso);
          datadinascita_slashes=datadinascita;
          datadinascita_slashes.insert(2,"/");
          datadinascita_slashes.insert(5,"/");
          
         paint.drawText( 65, 128, cognome );
         paint.drawText( 65, 146, nome );
            paint.drawText( 275, 145, QString(sex) );
         paint.drawText( 65, 162, comune_attuale.nomecitta );
         paint.drawText( 65, 178, comune_attuale.sigla );
            paint.drawText( 220, 178, datadinascita_slashes );
         
        //**************************************************
        
         paint.end();
         
         finestratessera=new MostraTessera(this,"tessera");
         finestratessera->pict = new QPixmap(tessera);
         finestratessera->setFixedSize(341,201);
         
         finestratessera->show();
 }
}


