/***************************************************************************
                           kodicefiscale.cpp
                         -------------------
    begin                : sab dic  9 01:13:33 CET 2000
    copyright            : (C) 2000 by Samuele Catuzzi
    email                : samuele_catuzzi@yahoo.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kodicefiscale.h"
#include <kapp.h>
#include <kstddirs.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kaboutdata.h>
#include <kiconloader.h>
#include <kwin.h>
#include <kaboutapplication.h>
#include <kaboutkde.h>
#include <kpopupmenu.h>

//#include <qstring.h>
#include <qtooltip.h>

Kodicefiscale::Kodicefiscale(QWidget *parent,const char *name) : KMainWindow(parent,name)
{
 dialog_window=new FinestraPrincipale(this,"wow");

 this->resize( 325, 240 );

 /*
  *  Questa funzione deriva dalla classe KGlobal (kdecore) e va a sostituirsi
  *  al precedente metodo per trovare le risorse dell'applicazione
  *
  */
 dialog_window->posizione_comuni=locate("data","kodicefiscale/comuni.bin");

 KIconLoader *ld = KGlobal::iconLoader();

 // ricreo tutto il menu help in modo da non avere "ReportBug" e la documentazione
 KPopupMenu *help = new KPopupMenu();
 help->insertItem( SmallIcon("kodicefiscale"), i18n("&About kodicefiscale"), this, SLOT(About_slot()) );
 help->insertItem( SmallIcon("go"),i18n("About &KDE"), this ,SLOT(Aboutkde_slot()));


 fileMenu = new QPopupMenu();
 fileMenu->insertItem( SmallIcon("exit"), i18n("E&xit"), kapp, SLOT(closeAllWindows()) );


 menuBar()->insertItem(i18n("&File"), fileMenu);
 menuBar()->insertSeparator();
 menuBar()->insertItem( i18n("&Help"), help );

 this->setHelpMenuEnabled(false);

 Dock = new SystemTray(this,"Dock");
 Dock->setPixmap(ld->loadIcon("kodicefiscale",KIcon::Panel,KIcon::SizeSmall));
 Dock->show();

 dialog_window->importadati();
 dialog_window->SetupChiudiApplicazione();

}

Kodicefiscale::~Kodicefiscale()
{
}

/** No descriptions */
void Kodicefiscale::About_slot(){
	KAboutApplication *aboutx = new KAboutApplication(this,"aboutx");
	aboutx->show();
}
/** No descriptions */
void Kodicefiscale::Aboutkde_slot(){
	KAboutKDE *aboutx = new KAboutKDE(this,"aboutx");
	aboutx->show();
}
