/***************************************************************************
 *   Copyright (C) 2004 by Samuele Catuzzi                                 *
 *   samuele_catuzzi@yahoo.it                                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mostratessera.h"
#include <qpopupmenu.h>
#include <qpainter.h>
#include <kfiledialog.h>

MostraTessera::MostraTessera(QWidget *parent, const char *name)
 : QDialog(parent, name)
{

   saveAct = new QAction(QString("Salva immagine"), QString("Ctrl+S"), this);
   //saveAct->setIconSet(QPixmap::fromMimeSource("immaginina.png"));
   saveAct->setStatusTip(QString("Salva immagine della tessera del codicefiscale"));
   
   connect(saveAct, SIGNAL(activated()), this, SLOT(saveFile()));
  

}


MostraTessera::~MostraTessera()
{
   delete pict;
}


#include "mostratessera.moc"


/*!
    \fn MostraTessera::paintEvent( QPaintEvent * )
 */
void MostraTessera::paintEvent( QPaintEvent * )
{
    QPainter paint( this );               // paint widget
    if ( pict )
        paint.drawPixmap( 0,0, *pict );   // draw pixmap

}


/*!
    \fn MostraTessera::keyPressEvent( QKeyEvent * )
 */
void MostraTessera::keyPressEvent( QKeyEvent * )
{
    /// @todo implement me
}


/*!
    \fn MostraTessera::contextMenuEvent(QContextMenuEvent *event)
 */
void MostraTessera::contextMenuEvent(QContextMenuEvent *event)
{

  QPopupMenu contextMenu(this); 
  saveAct->addTo(&contextMenu);
  contextMenu.exec(event->globalPos());

}


/*!
    \fn MostraTessera::saveFile()
 */
void MostraTessera::saveFile()
{

  QString nomefile = KFileDialog::getSaveFileName(
                    QString::null,
                    "*.png",
                    this,
                    "salva immagine tessera" );
  if ( !nomefile.isEmpty() )
        pict->save(nomefile,"PNG");

}

