/***************************************************************************
                          systemtray.cpp  -  description
                             -------------------
    begin                : Fri Jun 23 2000
    copyright            : (C) 2000 by Catuzzi Samuele
    email                : samuele_catuzzi@yahoo.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kwin.h>

#include "systemtray.h"
// special thanks to QTrans application for this class , grazie.

SystemTray::SystemTray( QWidget *parent, const char *name )
   : KSystemTray( parent, name )
{
     Par = parent;
     
     Menu = new KPopupMenu(this,"Systemtrayicona");
     Menu->insertTitle(SmallIcon("kodicefiscale") ,i18n("Kodicefiscale"));
  Menu->insertItem( SmallIcon("exit"), i18n("E&xit"), kapp, SLOT(closeAllWindows()) );

//   Menu->insertSeparator();
     Menu->insertItem(SmallIcon("contents"),i18n("&About"), parent,SLOT(About_slot()),0,1);

}

SystemTray::~SystemTray()
{
}

void SystemTray::mousePressEvent(QMouseEvent *e)
{
     if (!rect().contains(e->pos()))
     return;

     switch (e->button()) {
     case LeftButton:
          if ( Par->isVisible() ) {
               Par->hide();
          } else {
               #if KDE_VERSION < 320
               if (KWin::currentDesktop() != KWin::info(Par->winId()).desktop)
               KWin::setOnDesktop(Par->winId(),KWin::currentDesktop());
               #else
               if (KWin::currentDesktop() != KWin::windowInfo(Par->winId()).desktop())
               KWin::setOnDesktop(Par->winId(),KWin::currentDesktop());
               #endif

               Par->show();
               
               #if KDE_VERSION < 320
               KWin::setActiveWindow(Par->winId());
               #else
               KWin::activateWindow(Par->winId());
               #endif
          }
          break;
     case MidButton:
     case RightButton:
          Menu->popup(e->globalPos());
          break;
     default:
          break;
     }
}
