#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _progress_dialog_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkWindow\" id=\"window1\">"
"    <property name=\"visible\">True</property>"
"    <property name=\"title\">window1</property>"
"    <child>"
"      <widget class=\"GtkEventBox\" id=\"ProgressDialog\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkAlignment\" id=\"alignment5\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"bottom_padding\">12</property>"
"            <property name=\"left_padding\">12</property>"
"            <property name=\"right_padding\">12</property>"
"            <child>"
"              <widget class=\"GtkTable\" id=\"table1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"n_rows\">2</property>"
"                <property name=\"n_columns\">2</property>"
"                <child>"
"                  <placeholder/>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment4\">"
"                    <property name=\"width_request\">250</property>"
"                    <property name=\"height_request\">70</property>"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xscale\">0</property>"
"                    <property name=\"yscale\">0</property>"
"                    <property name=\"top_padding\">12</property>"
"                    <child>"
"                      <widget class=\"GtkProgressBar\" id=\"progressbar\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"fraction\">0.5</property>"
"                        <property name=\"pulse_step\">0.10000000149</property>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"right_attach\">2</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment3\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xalign\">1</property>"
"                    <property name=\"xscale\">0</property>"
"                    <child>"
"                      <widget class=\"GtkButton\" id=\"cancel\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"label\">gtk-cancel</property>"
"                        <property name=\"use_stock\">True</property>"
"                        <property name=\"response_id\">0</property>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"left_attach\">1</property>"
"                    <property name=\"right_attach\">2</property>"
"                    <property name=\"top_attach\">1</property>"
"                    <property name=\"bottom_attach\">2</property>"
"                    <property name=\"x_options\">GTK_FILL</property>"
"                    <property name=\"y_options\"></property>"
"                  </packing>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct ProgressDialogXml ProgressDialogXml;

struct ProgressDialogXml {
    MooGladeXML *xml;

    GtkEventBox *ProgressDialog;
    GtkProgressBar *progressbar;
    GtkButton *cancel;
};

static void
_progress_dialog_xml_free (ProgressDialogXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static ProgressDialogXml *
progress_dialog_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
progress_dialog_xml_build (ProgressDialogXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _progress_dialog_xml_glade_xml, -1, "ProgressDialog", NULL);
    xml->ProgressDialog = moo_glade_xml_get_widget (xml->xml, "ProgressDialog");
    xml->progressbar = moo_glade_xml_get_widget (xml->xml, "progressbar");
    xml->cancel = moo_glade_xml_get_widget (xml->xml, "cancel");
    g_object_set_data_full (G_OBJECT (xml->ProgressDialog), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _progress_dialog_xml_free);
}

static ProgressDialogXml *
progress_dialog_xml_new_empty (void)
{
    ProgressDialogXml *xml = g_new0 (ProgressDialogXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static ProgressDialogXml *
progress_dialog_xml_new (void)
{
    ProgressDialogXml *xml = progress_dialog_xml_new_empty ();
    progress_dialog_xml_build (xml);
    return xml;
}
