#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _save_mult_dialog_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"SaveMultDialog\">"
"    <property name=\"modal\">True</property>"
"    <property name=\"window_position\">GTK_WIN_POS_CENTER_ON_PARENT</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <property name=\"has_separator\">False</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkAlignment\" id=\"alignment\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"top_padding\">6</property>"
"            <property name=\"bottom_padding\">6</property>"
"            <property name=\"left_padding\">6</property>"
"            <property name=\"right_padding\">6</property>"
"            <child>"
"              <widget class=\"GtkTable\" id=\"table1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"n_rows\">3</property>"
"                <property name=\"n_columns\">2</property>"
"                <property name=\"column_spacing\">6</property>"
"                <property name=\"row_spacing\">6</property>"
"                <child>"
"                  <placeholder/>"
"                </child>"
"                <child>"
"                  <placeholder/>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkImage\" id=\"image1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"stock\">gtk-dialog-warning</property>"
"                    <property name=\"icon_size\">6</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"x_options\">GTK_FILL</property>"
"                    <property name=\"y_options\">GTK_FILL</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xalign\">0</property>"
"                    <property name=\"label\">&lt;span weight=\"bold\" size=\"larger\"&gt;There are n documents with unsaved changes. Save changes before closing?&lt;/span&gt;</property>"
"                    <property name=\"use_markup\">True</property>"
"                    <property name=\"wrap\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"left_attach\">1</property>"
"                    <property name=\"right_attach\">2</property>"
"                    <property name=\"x_options\">GTK_FILL</property>"
"                    <property name=\"y_options\"></property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label2\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xalign\">0</property>"
"                    <property name=\"label\" translatable=\"yes\">Select the documents you want to save:</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"left_attach\">1</property>"
"                    <property name=\"right_attach\">2</property>"
"                    <property name=\"top_attach\">1</property>"
"                    <property name=\"bottom_attach\">2</property>"
"                    <property name=\"x_options\">GTK_FILL</property>"
"                    <property name=\"y_options\"></property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkScrolledWindow\" id=\"scrolledwindow1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"can_focus\">False</property>"
"                    <property name=\"hscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"                    <property name=\"vscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"                    <property name=\"shadow_type\">GTK_SHADOW_IN</property>"
"                    <child>"
"                      <widget class=\"GtkTreeView\" id=\"treeview\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"headers_visible\">False</property>"
"                        <property name=\"enable_search\">False</property>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"left_attach\">1</property>"
"                    <property name=\"right_attach\">2</property>"
"                    <property name=\"top_attach\">2</property>"
"                    <property name=\"bottom_attach\">3</property>"
"                    <property name=\"x_options\">GTK_FILL</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct SaveMultDialogXml SaveMultDialogXml;

struct SaveMultDialogXml {
    MooGladeXML *xml;

    GtkDialog *SaveMultDialog;
    GtkAlignment *alignment;
    GtkLabel *label;
    GtkTreeView *treeview;
};

static void
_save_mult_dialog_xml_free (SaveMultDialogXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static SaveMultDialogXml *
save_mult_dialog_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
save_mult_dialog_xml_build (SaveMultDialogXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _save_mult_dialog_xml_glade_xml, -1, "SaveMultDialog", NULL);
    xml->SaveMultDialog = moo_glade_xml_get_widget (xml->xml, "SaveMultDialog");
    xml->alignment = moo_glade_xml_get_widget (xml->xml, "alignment");
    xml->label = moo_glade_xml_get_widget (xml->xml, "label");
    xml->treeview = moo_glade_xml_get_widget (xml->xml, "treeview");
    g_object_set_data_full (G_OBJECT (xml->SaveMultDialog), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _save_mult_dialog_xml_free);
}

static SaveMultDialogXml *
save_mult_dialog_xml_new_empty (void)
{
    SaveMultDialogXml *xml = g_new0 (SaveMultDialogXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static SaveMultDialogXml *
save_mult_dialog_xml_new (void)
{
    SaveMultDialogXml *xml = save_mult_dialog_xml_new_empty ();
    save_mult_dialog_xml_build (xml);
    return xml;
}
