#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _goto_line_dialog_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"GotoLineDialog\">"
"    <property name=\"title\" translatable=\"yes\">Go to Line</property>"
"    <property name=\"window_position\">GTK_WIN_POS_CENTER_ON_PARENT</property>"
"    <property name=\"destroy_with_parent\">True</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <property name=\"skip_taskbar_hint\">True</property>"
"    <property name=\"skip_pager_hint\">True</property>"
"    <property name=\"has_separator\">False</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkVBox\" id=\"vbox1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"border_width\">6</property>"
"            <child>"
"              <widget class=\"GtkLabel\" id=\"label5\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"xalign\">0</property>"
"                <property name=\"label\" translatable=\"yes\">Go to line:</property>"
"              </widget>"
"              <packing>"
"                <property name=\"expand\">False</property>"
"                <property name=\"fill\">False</property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkHBox\" id=\"hbox2\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"spacing\">3</property>"
"                <child>"
"                  <widget class=\"GtkHScale\" id=\"scale\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"adjustment\">1 1 20 1 10 1</property>"
"                    <property name=\"draw_value\">False</property>"
"                  </widget>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkSpinButton\" id=\"spin\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"has_focus\">True</property>"
"                    <property name=\"adjustment\">1 1 20 1 10 10</property>"
"                    <property name=\"climb_rate\">1</property>"
"                    <property name=\"numeric\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"position\">1</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"expand\">False</property>"
"                <property name=\"fill\">False</property>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancel_btn\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-cancel</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-6</property>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"ok_btn\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"has_default\">True</property>"
"                <property name=\"label\">gtk-ok</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-5</property>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct GotoLineDialogXml GotoLineDialogXml;

struct GotoLineDialogXml {
    MooGladeXML *xml;

    GtkDialog *GotoLineDialog;
    GtkHScale *scale;
    GtkSpinButton *spin;
    GtkButton *cancel_btn;
    GtkButton *ok_btn;
};

static void
_goto_line_dialog_xml_free (GotoLineDialogXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static GotoLineDialogXml *
goto_line_dialog_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
goto_line_dialog_xml_build (GotoLineDialogXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _goto_line_dialog_xml_glade_xml, -1, "GotoLineDialog", NULL);
    xml->GotoLineDialog = moo_glade_xml_get_widget (xml->xml, "GotoLineDialog");
    xml->scale = moo_glade_xml_get_widget (xml->xml, "scale");
    xml->spin = moo_glade_xml_get_widget (xml->xml, "spin");
    xml->cancel_btn = moo_glade_xml_get_widget (xml->xml, "cancel_btn");
    xml->ok_btn = moo_glade_xml_get_widget (xml->xml, "ok_btn");
    g_object_set_data_full (G_OBJECT (xml->GotoLineDialog), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _goto_line_dialog_xml_free);
}

static GotoLineDialogXml *
goto_line_dialog_xml_new_empty (void)
{
    GotoLineDialogXml *xml = g_new0 (GotoLineDialogXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static GotoLineDialogXml *
goto_line_dialog_xml_new (void)
{
    GotoLineDialogXml *xml = goto_line_dialog_xml_new_empty ();
    goto_line_dialog_xml_build (xml);
    return xml;
}
