#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _log_window_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkWindow\" id=\"LogWindow\">"
"    <property name=\"title\">Log</property>"
"    <property name=\"default_width\">400</property>"
"    <property name=\"default_height\">300</property>"
"    <child>"
"      <widget class=\"GtkScrolledWindow\" id=\"scrolledwindow1\">"
"        <property name=\"visible\">True</property>"
"        <property name=\"can_focus\">False</property>"
"        <property name=\"hscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"        <property name=\"vscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"        <property name=\"shadow_type\">GTK_SHADOW_ETCHED_IN</property>"
"        <child>"
"          <widget class=\"GtkTextView\" id=\"textview\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"editable\">False</property>"
"            <property name=\"wrap_mode\">GTK_WRAP_CHAR</property>"
"            <property name=\"cursor_visible\">False</property>"
"          </widget>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct LogWindowXml LogWindowXml;

struct LogWindowXml {
    MooGladeXML *xml;

    GtkWindow *LogWindow;
    GtkTextView *textview;
};

static void
_log_window_xml_free (LogWindowXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static LogWindowXml *
log_window_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
log_window_xml_build (LogWindowXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _log_window_xml_glade_xml, -1, "LogWindow", NULL);
    xml->LogWindow = moo_glade_xml_get_widget (xml->xml, "LogWindow");
    xml->textview = moo_glade_xml_get_widget (xml->xml, "textview");
    g_object_set_data_full (G_OBJECT (xml->LogWindow), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _log_window_xml_free);
}

static LogWindowXml *
log_window_xml_new_empty (void)
{
    LogWindowXml *xml = g_new0 (LogWindowXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static LogWindowXml *
log_window_xml_new (void)
{
    LogWindowXml *xml = log_window_xml_new_empty ();
    log_window_xml_build (xml);
    return xml;
}
