#ifndef _TINPUTLINE_H
#define _TINPUTLINE_H

#ifdef __WIN32__
#include <windows.h>
#else
#include "arect.h"
#endif

#include <astring.h>
#include "calctypes.h"

const int 
   ilsAllowNumber     = 0x0001,
   ilsAllowDot        = 0x0002,
   ilsAllowSeparator  = 0x0004,
   ilsAllowChar       = 0x0008,
   ilsAllowBrace      = 0x0010,
   ilsAllowString     = 0x0020,
   ilsAllowExpression = 0x0040,
   ilsAllowOperator   = 0x0080,
   ilsAllowFunc       = 0x0100,
   ilsAllowSymbol     = 0x0200,
   
   ilsAllStyles       = 0xFFFF;
   
class TLCDDisplay;
//---------------------------------------------------------------------------
class TInputLine 
{
   private:
   int Style;

   public:
   RECT r;
   TLCDDisplay* Owner;
   AnsiString Buffer;
   int CurPos;
   int VisPos;
   
   TInputLine( TLCDDisplay* AOwner );
   ~TInputLine();
   
   void SetRect( RECT ar );
   void Draw( void );
   
   void SetStyle( int AStyle ) { Style = AStyle; }
   int GetStyle( void ) { return Style; }
   
   void Clear( void );
   int Length( void );
   void InsertText( AnsiString Text );
   void SetSign( void );
   bool ExecAction( TButtonAction& Action );
   bool CursorLeft( int Chrs = 1 );
   bool CursorRight( int Chrs = 1 );
   bool CursorHome( void );
   bool CursorEnd( void );
   bool SetCursorPos( int APos );
   bool BackSpace( void );
};
//---------------------------------------------------------------------------
#endif // _TINPUTLINE

